package com.aliyun.drc.client.impl;

import com.aliyun.drc.client.DRCClientException;

/**
 * Encapsulate the daemon server information returned by the manager, including
 * server ip, port and client token.
 */
class DaemonInfo {

    private final String ip;
    private final String port;
    private final String token;

    DaemonInfo(final String ip, final String port, final String token)
        throws DRCClientException {
        if (ip == null || port == null || token == null) {
            throw new DRCClientException
            ("Returned daemon server info is not correct: " +
             ip + ":" + port + ":" + token);
        }

        this.ip = ip;
        this.port = port;
        this.token = token;
    }

    final String getIp() {
        return ip;
    }

    final String getPort() {
        return port;
    }

    /* Get the combination of ip and port for convenient use. */
    final String getIpPort() {
        return ip + ":" + port;
    }

    final String getToken() {
        return token;
    }
    
    @Override
    public String toString() {
    	return getIpPort() + ":" + token;
    }
}
