package com.aliyun.drc.client.impl;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Random;

/**
 * NsLooker is used to list all ips for one url randomly.
 * @author erbai.qzc
 *
 */
public class NsLooker {

	private static final String HTTP_MARK = "http://";
	private static NsLooker looker = null;

	public static NsLooker getInstance() {
		if (looker == null)
			looker = new NsLooker();
		return looker;
	}

	public String[] performNSLookup(final String ourl)
				throws UnknownHostException, MalformedURLException {

		String[] managers = null;
		final String url = ourl.startsWith(HTTP_MARK) ? ourl : HTTP_MARK + ourl;

		java.net.URL parsedUrl = new java.net.URL(url);
		if (!Character.isDigit(parsedUrl.getHost().charAt(0)))
		{ 
			// No number, so lookup all ips.
    		InetAddress[] inets = InetAddress.getAllByName(parsedUrl.getHost());
    		managers = new String[inets.length];
    		Random random = new Random();
    		int j = random.nextInt(managers.length);
    		for (int i = 0; i < inets.length; i++, j++) {
    			final String ip = inets[i].getHostAddress();
    			final String manager =  HTTP_MARK + ip + ":" +
    				Integer.toString(parsedUrl.getPort()) + parsedUrl.getPath();
    			if (j >= inets.length)
    				j -= inets.length;
    			managers[j] = manager;
    		}
    		return managers;
		}
		else {
			// Only one ip-port address.
			managers = new String[1];
			managers[0] = url;
			return managers;
		}
    }      	
}

