package com.aliyun.drc.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.aliyun.drc.client.message.DataMessage;

/*
* TBD: Add the strategy to package one huge transaction and
* allow the parameters for records and timeout per batch.
*/
public class RecordsCache {

	private int maxRecordsCached = 10240;
	private int maxTxnsBatched = 10240;
	private int maxRecordsBatched = 1024;
	private long maxTimeoutBatched = 500; // ms
	private boolean inTransaction;
	private List<DataMessage.Record> readyRecords;
	private long numOfTxnsInReadyRecords;
	long messageId;
	private DataMessage cachedMessage;
	private List<DataMessage.Record> records;
	private long lastFetchedTime; 

	public RecordsCache(DRCConfig config) {
		inTransaction = false;
		records = new ArrayList<DataMessage.Record>();
		readyRecords = new ArrayList<DataMessage.Record>();
		lastFetchedTime = System.currentTimeMillis();
		maxRecordsCached = config.getMaxRecordsPerTxn();
		maxRecordsBatched = config.getMaxRecordsBatched();
		maxTimeoutBatched = config.getMaxTimeoutBatched();
		maxTxnsBatched = config.getMaxTxnsBatched();
		messageId = 0;
		numOfTxnsInReadyRecords = 0;
	}

	public void setMaxRecordsCached(int count) {
		maxRecordsCached = count;
	}

	public void setmaxRecordsBatched(int count) {
		maxRecordsBatched = count;
	}

	public void setMaxTxnsBatched(int count) {
		maxTxnsBatched = count;
	}
	
	public void setmaxTimeoutBatched(long timeout) {
		maxTimeoutBatched = timeout;
	}
	
	public boolean isInTransaction() {
		return inTransaction;
	}

	public void setInTransaction(boolean txn) {
		inTransaction = txn;
	}
	
	public boolean isReady() {
		if (readyRecords.size() >= maxRecordsBatched ||
				numOfTxnsInReadyRecords >= maxTxnsBatched)
			return true;
		long now = System.currentTimeMillis();
		if (!readyRecords.isEmpty() && now - lastFetchedTime >= maxTimeoutBatched)
			return true;
		return false;
	}

	public DataMessage getReadyRecords() {
		cachedMessage = new DataMessage();
		cachedMessage.setId(messageId ++); 
		for (DataMessage.Record r : readyRecords) {
			cachedMessage.addRecord(r);
		}
		readyRecords.clear();
		numOfTxnsInReadyRecords = 0;
		lastFetchedTime = System.currentTimeMillis();
		return cachedMessage;
	}

	public void addRecord(DataMessage.Record r) throws IOException {
        switch (r.getOpt()) {
		case HEARTBEAT:
			if (inTransaction == false)
				readyRecords.add(r);
			else
				records.add(r);
			break;
		case BEGIN:
			if (inTransaction == true)
				records.clear();
			records.add(r);
			inTransaction = true;
			break;
		case COMMIT:
		case ROLLBACK:
			if (inTransaction == false)
				records.clear();
			else {
				inTransaction = false;
				records.add(r);
				readyRecords.addAll(records);
				numOfTxnsInReadyRecords ++;
				records.clear();
			}
			break;
		case INSERT:
		case DELETE:
		case UPDATE:
        case REPLACE:
			if (inTransaction == false) {
				records.clear();
			} else {
				records.add(r);
				if (records.size() >= maxRecordsCached) {
					readyRecords.addAll(records);
					records.clear();
				}
			}
			break;
		case DDL:
		default:
			if (inTransaction == true)
				records.add(r);
			else
				readyRecords.add(r);
			break;
		}
	}
}
