package com.aliyun.drc.client.impl;

import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.enums.ConnType;
import alibaba.drcnet.impl.DRCNETClientImpl;
import alibaba.drcnet.util.DRCNetMessageInfo;
import alibaba.drcnet.util.ServerTokenAuthTool;
import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.HttpBadResponseException;
import com.aliyun.drc.client.message.Message;
import com.aliyun.drc.utils.DefaultServerAuthTool;
import com.aliyun.drc.utils.NetUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

import java.io.*;
import java.net.URLEncoder;
import java.util.*;
import java.util.Map.Entry;

class ServerProxy {
    /* Url for the service, which could be configure service or data service */
    private String url;

    /* Private http handler send and get data by httpclient package */
    private HttpHandler handler;

    private DRCNETClientImpl drcNetHandler = null;

    private DRCNetMessageInfo messageInfo = null;

    private final Queue<Message> priorMessages;

    private DRCConfig drcConfig;

    public static final String DEFAULT_URL_ENCODING = "UTF-8";

    /**
     * Communicate with server by url, such as http://ip:port/task/start.
     *
     * @param url the location of the host.
     */
    ServerProxy(final String url, DRCConfig drcConfig) {
        this.url = url;
        this.drcConfig=drcConfig;
        handler = new HttpHandler(this.url, drcConfig.getUseHTTPS());
        priorMessages = new LinkedList<Message>();
    }

    void setSocketTimeout(int timeout) {
        handler.setSocketTimeout(timeout);
    }

    void setConnectionTimeout(int timeout) {
        handler.setConnectionTimeout(timeout);
    }

    /**
     * Add one parameter to the http request.
     *
     * @param key   is the key of the parameter.
     * @param value is the value of the parameter.
     */
    final void addParam(final String key, final String value) {
        handler.addFormParam(key, value);
    }

    /**
     * Add parameters to the http request.
     *
     * @param props is the map of the parameters.
     */
    final void addParams(final Map<String, String> props) {
        for (Entry<String, String> kv : props.entrySet()) {
            addParam(kv.getKey(), kv.getValue());
        }
    }

    /**
     * Check if a required parameter is added into the http handler.
     *
     * @param parameterName the name of the parameter.
     * @return true if found, false if not.
     */
    final boolean hasRequired(final String parameterName) {
        boolean found = false;
        for (NameValuePair param : handler.getFormParams()) {
            if (param.getName().equalsIgnoreCase(parameterName)) {
                found = true;
            }
        }

        return found;
    }

    /**
     * Get url of the server.
     *
     * @return url of the server.
     */
    final String getUrl() {
        return url;
    }

    /**
     * TBD: Must be executed: sending the request and getting meta data.
     *
     * @throws IOException
     * @throws HttpBadResponseException
     */
    final void sendRequest(final boolean decorated)
            throws HttpBadResponseException, IOException {
        try {
            if (decorated) {

                /* Use escape code. */
                handler.sendEncodedRequest();
            } else {
                /* Use source code. */
                handler.sendPlainRequest();
            }
        } catch (HttpBadResponseException he) {
            /* Necessary for recording failed daemon info. */
            //infoLogger.severe
            //(DRCConfig.SERVER_FAILED_MSG + " " + connectionInfo.toString());
            throw he;
        } catch (IOException e) {
            throw e;
        }
        

        /* First response is the  */
        // final Message response = handler.recvDRCPResponse();
        // return response.getMessage();
    }

    private boolean needEncodingForDRCNet(String keyName) {
        if (StringUtils.equalsIgnoreCase(keyName, "password") ||
                StringUtils.equalsIgnoreCase(keyName, "username") ||
                StringUtils.equalsIgnoreCase(keyName, "group")) {
            return true;
        } else {
            return false;
        }
    }

    void conncetToDrcNetServer(final String ip, final String port, int connctionTimeOut) throws IOException, DRCClientException {
        byte[] connectResponse = handler.recv();
        if (connectResponse == null) {
            throw new DRCClientException("get drcnet failed from server");
        }
        if (connectResponse.length > 10) {
            throw new DRCClientException("get drcnet failed from server: " + (new String(connectResponse)));
        }
        handler.close();

        int drcNetPort = Integer.parseInt(new String(connectResponse).replaceAll("[^0-9\\.]", ""));
        if (drcNetPort <= 0 || drcNetPort > 65535) {
            throw new DRCClientException("get drcnet failed from server: " + drcNetPort);
        }
        if (drcNetHandler == null) {
            drcNetHandler = new DRCNETClientImpl();
        } else {
            drcNetHandler.stopDRCNet();
            drcNetHandler = new DRCNETClientImpl();
        }
        Map<String, String> userMap = new HashMap<String, String>();
        List<NameValuePair> params = handler.getFormParams();
        if (params != null) {
            for (NameValuePair pair : params) {
                if (needEncodingForDRCNet(pair.getName())) {
                    userMap.put(pair.getName(), URLEncoder.encode(pair.getValue(), "UTF-8"));
                } else {
                    userMap.put(pair.getName(), pair.getValue());
                }
            }
        }
        // init config for drcnet encrypt protocol
        DRCNetConfig drcNetConfig = new DRCNetConfig();
        ConnType connType = ConnType.OLD_WAY_CONN;
        if(userMap.get("drcnet.encrypt") != null && userMap.get("drcnet.encrypt").equalsIgnoreCase("true")) {
            DefaultServerAuthTool authTool = new DefaultServerAuthTool();
            drcNetConfig.setServerTokenAuthTool(authTool);
            drcNetConfig.setClientAuthString(DefaultServerAuthTool.clientAuthToken);
            drcNetConfig.setClientAuthStringLen(DefaultServerAuthTool.clientAuthToken.length);
            drcNetConfig.setExtendString(DefaultServerAuthTool.extendInfo);
            drcNetConfig.setExtendStringLen(DefaultServerAuthTool.extendInfo.length);
            connType = ConnType.SINGLE_WITHID_ENCRYPT_CONN;
        }
        if (drcNetHandler.startDRCNet(ip, String.valueOf(drcNetPort), connType, drcNetConfig, userMap, connctionTimeOut) != 0) {
            throw new DRCClientException("start drcnet failed " + ip + ":" + port);
        }
        if (messageInfo == null) {
            messageInfo = new DRCNetMessageInfo();
        }
        if (messageInfo == null) {
            throw new DRCClientException("get drcnet message info failed");
        }
//    	DRCNetMessageInfo messageInfo = new DRCNetMessageInfo();
//    	if(userMap.containsKey("writer.type") && userMap.get("writer.type").equals("sizedData")) {
//    	//read 0 message
//    		drcNetHandler.readMsg(messageInfo);
//    		if(messageInfo.bufLen != 0) {
//    			throw new DRCClientException("drcnet read first failed");
//    		}
//    		drcNetHandler.readMsg(messageInfo);
//    	}

    }

    final Message getDrcNetResponse(boolean usebinary) throws Exception {
        Message priorMessage = priorMessages.poll();
        if (priorMessage != null)
            return priorMessage;
        int readRet = drcNetHandler.readMsg(messageInfo);

        if (readRet != 0) {
            throw new Exception("read drcnet failed, server shutdown");
        }
        try {
            if (usebinary) {
                if (messageInfo.bufLen == 0) {
                    //first message, the following message is store name for binary message format
                    //we read that out and abandon the message for current.
                    readRet = drcNetHandler.readMsg(messageInfo);
                    if (readRet != 0) {
                        throw new Exception("read drcnet failed, server shutdown");
                    }
                    //this is the real data, usually the begin record
                    readRet = drcNetHandler.readMsg(messageInfo);
                    if (readRet != 0) {
                        throw new Exception("read drcnet failed, server shutdown");
                    }
                }
                priorMessage = handler.recvDRCNetBinaryResponse(messageInfo.buf, drcConfig);
            } else {
                priorMessage = handler.recvDRCNetTextResponse(messageInfo.buf, drcConfig);
            }
        } catch (Exception e) {
            Exception toThrow = new Exception("raw buf:" + new String(messageInfo.buf), e.getCause());
            toThrow.setStackTrace(e.getStackTrace());
            throw toThrow;
        }
        return priorMessage;

    }

    final Message getResponse(boolean useBinary) throws Exception, DRCClientException {
        Message priorMessage = priorMessages.poll();
        if (priorMessage != null)
            return priorMessage;

        if (useBinary)
            priorMessage = handler.recvDRCPBinaryResponse(drcConfig);
        else
            priorMessage = handler.recvDRCPResponse(drcConfig);
        if (priorMessage == null)
            throw new DRCClientException("Get null message, server may shutdown.");
        return priorMessage;
    }

    final boolean setResponse(Message message) {
        return priorMessages.offer(message);
    }

    public static final boolean askIfCm(final String url, final DRCConfig drcConfig) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/status.taobao";
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        try {
            HttpResponse resp = client.execute(method);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
            String line = reader.readLine();
            client.close();
            if (line.equals("success & ok"))
                return true;
        } catch (Exception e) {
            // any exceptions direct it is not
            return false;
        }

        return false;
    }

    public static final TokenResp askToken(final String url, final String consumer, final String password, final DRCConfig drcConfig)
            throws IOException, HttpBadResponseException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/auth?consumer=" + URLEncoder.encode(consumer, DEFAULT_URL_ENCODING) + "&password=" + URLEncoder.encode(password, DEFAULT_URL_ENCODING);
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        HttpResponse resp = client.execute(method);
        ObjectMapper mapper = new ObjectMapper();
        TokenResp response = mapper.readValue(resp.getEntity().getContent(), TokenResp.class);
        client.close();
        if (response.getIsSuccess() == false) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        return response;
    }

    public static final void askRegionInfo(final String url, DRCConfig drcConfig, String subTopic) throws UnsupportedEncodingException{
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/region/id?subTopic=" + URLEncoder.encode(subTopic, DEFAULT_URL_ENCODING);
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        try {
            HttpResponse resp = client.execute(method);
            ObjectMapper mapper = new ObjectMapper();
            RegionResp response = mapper.readValue(resp.getEntity().getContent(), RegionResp.class);
            drcConfig.setRegionId(response.getRegionId());
        } catch (IOException e) {

        }finally {
            try {
                client.close();
            } catch (IOException e) {

            }
        }
    }

    public static final TopicsResp askTopics(final String url, final String db, final String token, final DRCConfig drcConfig)
            throws IOException, HttpBadResponseException, DRCClientException {

        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/list/" + db;
        HttpPost method = new HttpPost(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        List <NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("token", token));
        method.setEntity(new UrlEncodedFormEntity(params));
        HttpResponse resp = client.execute(method);
        ObjectMapper mapper = new ObjectMapper();

        TopicsResp response = mapper.readValue(resp.getEntity().getContent(), TopicsResp.class);
        client.close();
        if (response.getIsSuccess() == false) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        } else {
            if (response.getTopics().size() > 1) {
                throw new DRCClientException(db + " matches subtopics more than 1: "
                        + response.getTopics());
            }
        }
        return response;
    }

    public static final TypeResp askTopicType(final String url, final String topic, final DRCConfig drcConfig)
            throws ClientProtocolException, IOException, DRCClientException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String composedUrl = url + "/topic/query" + "?topic=" + URLEncoder.encode(topic, DEFAULT_URL_ENCODING);
        HttpGet method = new HttpGet(composedUrl);
        method.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        HttpResponse resp = client.execute(method);
        ObjectMapper mapper = new ObjectMapper();
        TypeResp response = mapper.readValue(resp.getEntity().getContent(), TypeResp.class);
        client.close();
        if (response.getIsSuccess() == false) {
            throw new DRCClientException(response.getErrCode() + ":" + response.getErrMsg());
        }
        return response;
    }


    public static final StoreResp askStore(final String url, final String subTopic, final String token, final DRCConfig drcConfig)
            throws IOException, HttpBadResponseException, DRCClientException {

        final Checkpoint checkpoint = new Checkpoint(drcConfig.getCheckpoint());
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url + "/storehost/" + subTopic);
        httpPost.setConfig(RequestConfig.custom().setSocketTimeout(drcConfig.getSocketTimeout() * 1000).setConnectTimeout(drcConfig.getConnectionTimeout() * 1000).build());
        List<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add(new BasicNameValuePair("token", token));
        String cpStr = checkpoint.toString();
        String cpArray[] = cpStr.split(":", -1);
        String ip = cpArray[0];
        if (!StringUtils.isEmpty(ip) && ip.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+")) {
            long l = NetUtils.ipToLong(ip);
            cpStr = l + ":" + cpArray[1] + ":" + cpArray[2] + ":" + cpArray[3] + ":" + cpArray[4] + ":" + cpArray[5];
        }
        nvps.add(new BasicNameValuePair("checkpoint", cpStr));
        nvps.add(new BasicNameValuePair("filter", URLEncoder.encode(drcConfig.getDataFilter().toString(), "ISO-8859-1").toString()));
        if (drcConfig.isUsePublicIp()) {
            nvps.add(new BasicNameValuePair("publicIp", "true"));
        }
        if (drcConfig.getGuid() != null) {
            nvps.add(new BasicNameValuePair("guid", drcConfig.getGuid()));
        }
        httpPost.setEntity(new UrlEncodedFormEntity(nvps, "UTF8"));
        HttpResponse resp = client.execute(httpPost);
        ObjectMapper mapper = new ObjectMapper();
        StoreResp response = mapper.readValue(resp.getEntity().getContent(), StoreResp.class);

        client.close();;
        if (response.getIsSuccess() == false) {
            throw new HttpBadResponseException(response.getErrCode(), response.getErrMsg());
        }
        return response;
    }

    final void close() {
        handler.close();
        if (drcNetHandler != null) {
            drcNetHandler.stopDRCNet();
        }
    }
}
