package com.aliyun.drc.client.message;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.message.drcmessage.TextDecodeStateMachine;

/**
 * Message builder to build any messages from the DataInputStream.
 * @author erbai.qzc<erbai.qzc@taobao.com>
 *
 */
public class Builder {

    private long id = 0;

    private static final String message_id = "message_id";
    private static final String message_type = "message_type";
    private static final int data_type = 100;
    private static final int monitor_type = 200;
    private static final int redirect_type = 300;
    private static final int error_type = 400;
    private  TextDecodeStateMachine textDrcodeMachine = new TextDecodeStateMachine();
    public Message buildBinaryBinlog(DataInputStream reader,DRCConfig drcConfig) throws IOException {
        DataMessage message = new DataMessage();
        message.setId(id ++);
        message.setType(data_type);
        message.mergeFromBinary(reader,drcConfig);
        return message;
    }

    public Message buildDRCNetBinaryBinlog(byte[] buff,DRCConfig drcConfig) throws Exception {
        DataMessage message = new DataMessage();
        message.setId(id ++);
        message.setType(data_type);
        message.mergeFromDrcNETBinary(buff,drcConfig);
        return message;
    }
    public Message buildDRCNetTextBinlog(byte[] buff,DRCConfig drcConfig) throws Exception {
        return textDrcodeMachine.runStateMachine(buff,drcConfig);
    }

//	public Message buildDrcNetBinaryBinlog()

    /**
     * The main method to build a message, which type is not known yet.
     * @param reader is the DataInputStream.
     * @return the built message.
     * @throws IOException
     */
    @SuppressWarnings("deprecation")
    public Message build(final DataInputStream reader,DRCConfig drcConfig)
            throws IOException {

        Message message;
        Map<String, String> attr = new HashMap<String, String>();
        String line;
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            String kv[] = line.split(":");
            if (kv.length != 2) {
                throw new IOException
                        ("Parse message attribute " + line + " error");
            }
            attr.put(kv[0], kv[1]);
        }

        if (line == null) {
            return null;
        }

        long id = Long.parseLong(attr.get(message_id));
        int type = Integer.parseInt(attr.get(message_type));

        switch(type) {
            case data_type:
                message = buildDataMessage(reader, id, type,drcConfig);
                break;
            case monitor_type:
                message = buildMonitorMessage(reader, id, type);
                break;
            case redirect_type:
                message = buildRedirectMessage(reader, id, type);
                break;
            case error_type:
                message = buildErrorMessage(reader, id, type);
                break;
            default:
                throw new IOException("Unexpected message type " + type);
        }

        message.addAttributes(attr);
        return message;
    }

    /**
     * Build ErrorMessage.
     * @param reader is the DataInputStream.
     * @param id is the message id.
     * @param type is the message type.
     * @return the ErrorMessage.
     * @throws IOException
     */
    private ErrorMessage buildErrorMessage(DataInputStream reader,
                                           long id,
                                           int type)
            throws IOException {

        ErrorMessage message = new ErrorMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader);
        return message;
    }

    /**
     * Build RedirectMessage.
     * @param reader is the DataInputStream.
     * @param id is the message id.
     * @param type is the message type.
     * @return the RedirectMessage.
     * @throws IOException
     */
    private RedirectMessage buildRedirectMessage(DataInputStream reader,
                                                 long id,
                                                 int type)
            throws IOException {

        RedirectMessage message = new RedirectMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader);
        return message;
    }

    /**
     * Build MonitorMessage.
     * @param reader is the DataInputStream.
     * @param id is the message id.
     * @param type is the message type.
     * @return the MonitorMessage.
     * @throws IOException
     */
    private MonitorMessage buildMonitorMessage(DataInputStream reader,
                                               long id,
                                               int type)
            throws IOException {

        MonitorMessage message = new MonitorMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader);
        return message;
    }

    /**
     * Build DataMessage.
     * @param reader is the DataInputStream.
     * @param id is the message id.
     * @param type is the message type.
     * @return the DataMessage.
     * @throws IOException
     */
    private DataMessage buildDataMessage(DataInputStream reader,
                                         long id,
                                         int type,DRCConfig drcConfig)
            throws IOException {

        DataMessage message = new DataMessage();
        message.setId(id);
        message.setType(type);
        message.mergeFrom(reader,drcConfig);
        return message;
    }
}
