package com.aliyun.drc.client.message;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Message containing error information.
 * @author erbai.qzc
 *
 */
public class ErrorMessage extends Message {

    /* 401 fatal 402 warn 403 notice. */
    private String errCode;
    private String errMsg;

    public ErrorMessage() {
        super();
    }

    /**
     * Get the error code from the message.
     * @return error code: 401 fatal 402 warn 403 notice.
     */
    public final String getCode() {
        return errCode;
    }

    /**
     * Get error message to help understand the error code.
     * @return error message.
     */
    public String getMessage() {
        return errMsg;
    }

    /**
     * Abstract error message from an input stream.  
     * @param in is the input stream.
     * @throws IOException
     */
    @SuppressWarnings("deprecation")
    void mergeFrom(final DataInputStream in) throws IOException {
        final String msg = in.readLine();
        if (msg == null || msg.isEmpty()) {
            throw new IOException("NULL or empty error message");
        }
        final String[] errors = msg.split(" ");
        errCode = errors[0];
        errMsg = msg;
    }

    @Override
    public String toString() {
    	StringBuilder builder = new StringBuilder();
    	builder.append(super.toString());
    	builder.append(errCode + " " + errMsg);
    	builder.append(System.getProperty("line.separator"));
    	return builder.toString();
    }
}
