package com.aliyun.drc.client.message;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * MonitorMessage directs how to run a monitor, e.g., to switch on/off.
 * @author erbai.qzc
 *
 */
public class MonitorMessage extends Message {

	private String monitorName;
	private boolean switchOn;
	private String monitorIP;
	private String monitorPort;
	private static final String delimiter = " ";

	/**
	 * Constructor of MonitorMessage.
	 */
	public MonitorMessage() {
		super();
	}

	/**
	 * Get the name of the monitor.
	 * @return the name of the monitor.
	 */
	public String getName() {
		return monitorName;
	}

	/**
	 * Set the name of the monitor.
	 * @param name the name of the monitor.
	 */
	public void setName(final String name) {
		monitorName = name;
	}

	/**
	 * Whether the monitor will be turned on.
	 * @return whether the monitor turned on.
	 */
	public boolean willOn() {
		return switchOn;
	}

	/**
	 * Turn the monitor on.
	 */
	public void switchOn() {
		switchOn = true;
	}

	/**
	 * Turn the monitor off.
	 */
	public void switchOff() {
		switchOn = false;
	}

	/**
	 * Get the ip of the monitor center.
	 * @return the ip of the monitor center.
	 */
	public String getIP() {
		return monitorIP;
	}

	/**
	 * Set the ip of the monitor center.
	 * @param ip is the ip of the monitor center.
	 */
	public void setIP(final String ip) {
		monitorIP = ip;
	}

	/**
	 * Get the port of the monitor center.
	 * @return the port of the monitor center.
	 */
	public String getPort() {
		return monitorPort;
	}

	/**
	 *  Set the port of the monitor center.
	 * @param port is the port of the monitor center.
	 */
	public void setPort(final String port) {
		monitorPort = port;
	}

	/**
	 * Construct a MonitorMessage.
	 * @param in is the input stream.
	 * @throws IOException
	 */
	@SuppressWarnings("deprecation")
	public void mergeFrom(final DataInputStream in) throws IOException {
		String line = in.readLine();
		String[] params = line.split(delimiter);
		if (params.length != 4) {
			throw new IOException("Parse monitor message " + line + " error");
		}
		monitorName = params[0];
		switchOn = params[1].equalsIgnoreCase("on") ? true : false;
		monitorIP = params[2];
		monitorPort = params[3];
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append(super.toString());
		builder.append(monitorName + delimiter + switchOn + delimiter +
				       monitorIP + delimiter + monitorPort + System.getProperty("line.separator"));
		return builder.toString();
	}
}
