package com.aliyun.drc.client.message.drcmessage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import com.aliyun.drc.client.message.ByteString;

public abstract class CIOUtil {
	public static final String CHARSET = "UTF-8";

	/**
	 * ???????????????? 
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static boolean readBoolean(DataInputStream is) throws IOException {
		return is.readBoolean();
	}

	/**
	 * ??????????????????????
	 * 
	 * @param is
	 * @param s
	 * @return
	 * @throws IOException
	 */
	public static byte[] readBytes(DataInputStream is, int i)
			throws IOException {
		byte[] data = new byte[i];
		is.readFully(data);

		return data;
	}

	/**
	 * ???????????????? 
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static char readChar(DataInputStream is) throws IOException {
		return (char) readShort(is);
	}

	/**
	 * ?????????????????? 
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static double readDouble(DataInputStream is) throws IOException {
		return Double.longBitsToDouble(readLong(is));
	}

	/**
	 * ??????????????????
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static float readFloat(DataInputStream is) throws IOException {
		return Float.intBitsToFloat(readInt(is));
	}

	/**
	 * ????????????
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static int readInt(DataInputStream is) throws IOException {
		return Integer.reverseBytes(is.readInt());
	}

	/**
	 * ??????????????????
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static long readUnsignedInt(DataInputStream is) throws IOException {
		return readInt(is) & 0x0FFFFFFFF;
	}

	/**
	 * ??????????????
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static long readLong(DataInputStream is) throws IOException {
		return Long.reverseBytes(is.readLong());
	}

	/**
	 * ??????????????
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static short readShort(DataInputStream is) throws IOException {
		return Short.reverseBytes(is.readShort());
	}

	/**
	 * ????????????????????
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static int readUnsignedShort(DataInputStream is) throws IOException {
		return readShort(is) & 0x0FFFF;
	}

	/**
	 * ?????????????????? ?????? ???? ?? ??????????????????????????????+??????????
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static ByteString readByteString(DataInputStream is) throws IOException {
		long l = readUnsignedInt(is);
		byte[] str = new byte[(int)l];
		
		is.readFully(str);
		
		return new ByteString(str,(int)l);
	}
	
	public static String readUTF(DataInputStream is) throws IOException {
		short s = readShort(is);
		byte[] str = new byte[s];

		is.readFully(str);

		return new String(str, CHARSET);
	}

	public static String readString(DataInputStream is, final String ENCODING) throws IOException {
		long l = readUnsignedInt(is);
		byte[] str = new byte[(int)l - 1];
		
		is.readFully(str);
		is.readByte(); // \0 

		return new String(str, ENCODING);
	}

	public static String readASCII(DataInputStream is) throws IOException {
		long l = readUnsignedInt(is);
		byte[] str = new byte[(int)l];
		
		is.readFully(str);

		return new String(str, "ASCII");
	}

	/**
	 * ????????????????
	 * 
	 * @param os
	 * @param b
	 * @throws IOException
	 */
	public static void writeBoolean(DataOutputStream os, boolean b)
			throws IOException {
		os.writeBoolean(b);
	}

	/**
	 * ????????????????????
	 * 
	 * @param os
	 * @param data
	 * @throws IOException
	 */
	public static void writeBytes(DataOutputStream os, byte[] data)
			throws IOException {
		os.write(data);
	}

	/**
	 * ????????????????
	 * 
	 * @param os
	 * @param b
	 * @throws IOException
	 */
	public static void writeChar(DataOutputStream os, char b)
			throws IOException {
		writeShort(os, (short) b);
	}

	/**
	 * ??????????????????
	 * 
	 * @param os
	 * @param d
	 * @throws IOException
	 */
	public static void writeDouble(DataOutputStream os, double d)
			throws IOException {
		writeLong(os, Double.doubleToLongBits(d));
	}

	/**
	 * ??????????????????
	 * 
	 * @param os
	 * @param f
	 * @throws IOException
	 */
	public static void writeFloat(DataOutputStream os, float f)
			throws IOException {
		writeInt(os, Float.floatToIntBits(f));
	}

	/**
	 * ????????????????
	 * 
	 * @param os
	 * @param i
	 * @throws IOException
	 */
	public static void writeInt(DataOutputStream os, int i) throws IOException {
		os.writeInt(Integer.reverseBytes(i));
	}

	/**
	 * ??????????????????
	 * 
	 * @param os
	 * @param l
	 * @throws IOException
	 */
	public static void writeLong(DataOutputStream os, long l)
			throws IOException {
		os.writeLong(Long.reverseBytes(l));
	}

	/**
	 * ??????????????????
	 * 
	 * @param os
	 * @param s
	 * @throws IOException
	 */
	public static void writeShort(DataOutputStream os, short s)
			throws IOException {
		os.writeShort(Short.reverseBytes(s));
	}

	/**
	 * ?????????????????? ?????? ???? ?? ??????????????????????????????+??????????
	 * 
	 * @param os
	 * @param str
	 * @throws IOException
	 */
	public static void writeUTF(DataOutputStream os, String str)
			throws IOException {
		byte[] data = str.getBytes(CHARSET);
		writeShort(os, (short) data.length);
		os.write(data);
	}
}
