package com.aliyun.drc.client.message.drcmessage;

import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.client.impl.DRCClientRunTimeException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.utils.BinaryMessageUtils;

public class DrcNETBinaryRecord extends DataMessage.Record {

    private static final String DEFAULT_ENCODING = "ASCII";

    private static final String SEP = System.getProperty("line.separator");
    //old version header length
    private static final int OLD_VERSION_2_HEADER_LEN = 88;

    //new version header length
    private static final int NEW_VERSION_2_HEADER_LEN = 96;

    private static final int VERSION_3_HEADER_LEN = 104;

    private static final int PREFIX_LENGTH = 12;

    private int brVersion = (byte) 0xff;

    private int srcType = (byte) 0xff;

    private int op = (byte) 0xff;

    private int lastInLogEvent = (byte) 0xff;

    private long srcCategory = -1;

    private long id = -1;

    private long timestamp = -1;

    private long encoding = -1;

    private long instanceOffset = -1;
    private long timeMarkOffset = -1;

    private long dbNameOffset = -1;

    private long tbNameOffset = -1;

    private long colNamesOffset = -1;

    private long colTypesOffset = -1;

    private long fileNameOffset = -1;

    private long fileOffset = -1;

    private long oldColsOffset = -1;

    private long newColsOffset = -1;

    private long pkKeysOffset = -1;

    private long ukColsOffset = -1;

    private long colsEncodingOffset = -1;

    private long filterRuleValOffset = -1;

    private long tailOffset = -1;

    /**
     * buf parse data
     */
    private String dbName;

    private String tableName;

    private String serverId;

    private List<Integer> primaryKeyIndexList;

    private String uniqueKeyList;

    private ByteBuf byteBuf;

    private List<String> pkValues;

    private List<Long> timeMarks = null;

    /**
     * type bitmap,get array type bytes by type index
     * array first byte : 1,  array element is unsigned byte
     *                    2,  array element is unsigned short
     *                    4,  array element is unsigned int
     *                    8,  array element is long
     *
     */
    private final static int[] elementArray = {0, 1, 1, 2, 2, 4, 4, 8, 8};

    private final static int BYTE_SIZE=1;

    private final static int INT_SIZE=Integer.SIZE/Byte.SIZE;

    private final CRC32 crc32 = new CRC32();

    private boolean isCheckCRC=false;

    public DrcNETBinaryRecord(boolean isCheckCRC){
        this.isCheckCRC=isCheckCRC;
    }

    public int getVersion() {
        return brVersion;
    }

    @Override
    public DBType getDbType() {
        switch (srcType) {
            case 0:
                return DBType.MYSQL;
            case 1:
                return DBType.OCEANBASE;
            case 2:
                return DBType.HBASE;
            case 3:
                return DBType.ORACLE;
            case 4:
                return DBType.OCEANBASE1;
            default:
                return DBType.UNKNOWN;
        }
    }
    @Override
    public boolean isQueryBack() {
        switch ((int) srcCategory) {
            case 1:
                return true;
            default:
                return false;
        }
    }

    @Override
    public boolean isFirstInLogevent() {
        return (lastInLogEvent == 1) ? true : false;
    }

    @Override
    public Type getOpt() {
        return Type.valueOf(op);
    }

    @Override
    public String getId() {
        return Long.toString(id);
    }

    @Override
    public String getDbname() {
        if (dbName == null) {
            if ((int) dbNameOffset < 0) {
                dbName = "";
            } else {
                try {
                    dbName = BinaryMessageUtils.getString(byteBuf.array(), (int) dbNameOffset, DEFAULT_ENCODING);
                } catch (Exception e) {
                    throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
                }
            }
        }
        return dbName == "" ? null : dbName;
    }

    @Override
    public final String getTablename() {
        if (tableName == null) {
            if ((int) tbNameOffset < 0) {
                tableName = "";
            } else {
                try {
                    tableName = BinaryMessageUtils.getString(byteBuf.array(), (int) tbNameOffset, DEFAULT_ENCODING);
                } catch (Exception e) {
                    throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
                }
            }
        }
        return tableName == "" ? null : tableName;
    }



    @Override
    public String getCheckpoint() {
        return fileOffset + "@" + fileNameOffset;
    }

    @Override
    public String getTimestamp() {
        return Long.toString(timestamp);
    }

    @Override
    public String getServerId() {
        if (serverId == null) {
            if ((int) instanceOffset < 0) {
                serverId = "";
            } else {
                try {
                    serverId = BinaryMessageUtils.getString(byteBuf.array(), (int) instanceOffset, DEFAULT_ENCODING);
                } catch (Exception e) {
                    throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
                }
            }
        }
        return serverId == "" ? null : serverId;
    }

    @Override
    public synchronized List<Field> getFieldList() {
        try {
            if (fields == null) {
                if (colNamesOffset < 0 || colTypesOffset < 0 || oldColsOffset < 0 || newColsOffset < 0) {
                    return fields;
                }
                //global encoding
                String encodingStr = BinaryMessageUtils.getString(byteBuf.array(), (int) encoding, DEFAULT_ENCODING);
                //pk info
                List<Integer> pks = null;
                if ((int) pkKeysOffset > 0) {
                    pks = BinaryMessageUtils.getArray(byteBuf.array(), (int) pkKeysOffset);
                }
                //get column count
                ByteBuf wrapByteBuf = Unpooled.wrappedBuffer(byteBuf.array()).order(ByteOrder.LITTLE_ENDIAN);
                wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + colNamesOffset+BYTE_SIZE));
                int count = wrapByteBuf.readInt();
                fields = new ArrayList<Field>(count);
                //op type array
                wrapByteBuf.readerIndex(PREFIX_LENGTH + (int) colTypesOffset);
                byte t = wrapByteBuf.readByte();
                int elementSize = elementArray[t & DataType.DT_MASK];
                //encoding
                int colEncodingsCount=0;
                int currentEncodingOffset=0;
                if(colsEncodingOffset>0) {
                    wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + colsEncodingOffset + BYTE_SIZE));
                    colEncodingsCount = wrapByteBuf.readInt();
                    currentEncodingOffset = (int) wrapByteBuf.readUnsignedInt();
                }
                //column name
                wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + colNamesOffset+BYTE_SIZE+INT_SIZE));
                int currentColNameOffset=(int) wrapByteBuf.readUnsignedInt();
                //old col value
                wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + oldColsOffset+BYTE_SIZE));
                int oldColCount = wrapByteBuf.readInt();
                int currentOldColOffset = -1;
                //Bug fix: if newCol count or old Count is 0, then the following offset should not be read;
                if (0 != oldColCount) {
                    currentOldColOffset = (int) wrapByteBuf.readUnsignedInt();
                }
                //new col value
                wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + newColsOffset+BYTE_SIZE));
                int newColCount = wrapByteBuf.readInt();
                int currentNewColOffset = -1;
                if (0 != newColCount) {
                    currentNewColOffset = (int) wrapByteBuf.readUnsignedInt();
                }

                //start loop
                for (int i = 0; i < count; i++) {
                    //get pk boolean
                    boolean isPk = false;
                    if (pks != null && pks.contains(i)) {
                        isPk = true;
                    }
                    //get real op type
                    int type = 0;
                    wrapByteBuf.readerIndex(PREFIX_LENGTH + (int) colTypesOffset + BYTE_SIZE+INT_SIZE+ i * elementSize);
                    switch (elementSize) {
                        case 1:
                            type = wrapByteBuf.readUnsignedByte();
                            break;
                        case 2:
                            type = wrapByteBuf.readUnsignedShort();
                            break;
                        case 4:
                            type = (int) wrapByteBuf.readUnsignedInt();
                            break;
                        case 8:
                            type = (int) wrapByteBuf.readLong();
                            break;
                    }
                    //get real encoding
                    String realEncoding = encodingStr;
                    wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + colsEncodingOffset+BYTE_SIZE+INT_SIZE+(i+1)*INT_SIZE));
                    if (colEncodingsCount >0) {
                        int nextEncodingOffset= (int) wrapByteBuf.readUnsignedInt();
                        ByteString encodingByteString=new ByteString(wrapByteBuf.array(), PREFIX_LENGTH +
                                currentEncodingOffset + BYTE_SIZE+INT_SIZE+(count+1)*INT_SIZE + (int) colsEncodingOffset, nextEncodingOffset - currentEncodingOffset - 1);
                        realEncoding = encodingByteString.toString();
                        if (realEncoding.isEmpty()) {
                            if ((type == 253 || type == 254) && Field.MYSQL_TYPES[type] == Field.Type.STRING) {
                                realEncoding = "binary";
                            } else if (Field.MYSQL_TYPES[type] == Field.Type.BLOB) {
                                realEncoding = "";
                            } else if (type == 245) {
                                realEncoding= UTF8MB4_ENCODING;
                            } else {
                                realEncoding = DEFAULT_ENCODING;
                            }
                        }
                        currentEncodingOffset=nextEncodingOffset;
                    }
                    //type change from blob to string if encoding is not empty
                    //Bug: This line should like following : Field.MYSQL_TYPES[type] == Field.Type.BLOB
                    //But the active of java2object will changed for text, medium text and long text
                    //And consumers using hard cord and treat source column  have text type as byte array
                    //which should be string actually.
                    if (!realEncoding.isEmpty() && type == Field.Type.BLOB.ordinal()) {
                        type = 15;
                    }
                    //colName
                    wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + colNamesOffset+BYTE_SIZE+INT_SIZE+(i+1)*INT_SIZE));
                    int nextColNameOffset= (int) wrapByteBuf.readUnsignedInt();
                    ByteString ColNameByteString=new ByteString(wrapByteBuf.array(), PREFIX_LENGTH +
                            currentColNameOffset +  BYTE_SIZE+INT_SIZE+(count+1)*INT_SIZE + (int) colNamesOffset, nextColNameOffset - currentColNameOffset - 1);
                    String columnName=ColNameByteString.toString();
                    currentColNameOffset=nextColNameOffset;
                    //old col
                    if (oldColCount != 0) {
                        wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + oldColsOffset+BYTE_SIZE+INT_SIZE+(i+1)*INT_SIZE));
                        int nextOldColOffset= (int) wrapByteBuf.readUnsignedInt();
                        ByteString value=null;
                        if(nextOldColOffset!=currentOldColOffset) {
                            value = new ByteString(wrapByteBuf.array(), PREFIX_LENGTH +
                                    currentOldColOffset + BYTE_SIZE + INT_SIZE + (count + 1) * INT_SIZE + (int) oldColsOffset, nextOldColOffset - currentOldColOffset - 1);
                        }
                        fields.add(new Field(columnName, type, realEncoding, value, isPk));
                        currentOldColOffset=nextOldColOffset;
                    }
                    //new col
                    if (newColCount != 0) {
                        wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + newColsOffset+BYTE_SIZE+INT_SIZE+(i+1)*INT_SIZE));
                        int nextNewColOffset= (int) wrapByteBuf.readUnsignedInt();
                        ByteString value =null;
                        if(currentNewColOffset!=nextNewColOffset){
                            value=new ByteString(wrapByteBuf.array(), PREFIX_LENGTH +
                                    currentNewColOffset +  BYTE_SIZE+INT_SIZE+(count+1)*INT_SIZE + (int) newColsOffset, nextNewColOffset - currentNewColOffset - 1);
                        }
                        fields.add(new Field(columnName, type, realEncoding, value, isPk));
                        currentNewColOffset=nextNewColOffset;
                    }
                }
            }

        } catch (Exception e){
            fields = null;
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }

        return fields;
    }
    public int getFieldCount() {
        return getFieldList().size();
    }

    public List getPrimaryKeyIndex() {
        try {
            if (primaryKeyIndexList == null) {
                if ((int) pkKeysOffset < 0) {
                    primaryKeyIndexList = new ArrayList<Integer>();
                } else {
                    primaryKeyIndexList = BinaryMessageUtils.getArray(byteBuf.array(), (int) pkKeysOffset);
                }
            }
        } catch (Exception e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
        return primaryKeyIndexList;
    }

    @Override
    public void parse(final byte[] data) throws Exception {
        ByteBuf inner = Unpooled.wrappedBuffer(data, 0, data.length).order(ByteOrder.LITTLE_ENDIAN);
        setByteBuf(inner);
    }




    /**
     * ����buffer offset
     *
     * @param byteBuf
     * @throws Exception
     *TODO: version conflict
     */
    public void setByteBuf(ByteBuf byteBuf) throws Exception {
        this.byteBuf = byteBuf;
        //omit first 12 bytes
        byteBuf.readerIndex(PREFIX_LENGTH);
        if ((byteBuf.readByte() & DataType.DT_MASK) != DataType.DT_UINT8) {
            throw new Exception("parse error");
        }
        long count = byteBuf.readInt();
        boolean old = false;
        switch ((int) count) {
            case OLD_VERSION_2_HEADER_LEN:
                old = true;
                break;
            case VERSION_3_HEADER_LEN:
            case NEW_VERSION_2_HEADER_LEN:
                break;
            default:
                throw new Exception("");
        }
        brVersion = byteBuf.readUnsignedByte();
        srcType = byteBuf.readUnsignedByte();
        op = byteBuf.readUnsignedByte();
        lastInLogEvent = byteBuf.readByte();
        srcCategory = byteBuf.readInt();
        id = byteBuf.readLong();
        timestamp = byteBuf.readLong();
        encoding = byteBuf.readInt();
        instanceOffset = byteBuf.readInt();
        //get timeMark
        timeMarkOffset = byteBuf.readInt();
        dbNameOffset = byteBuf.readInt();
        tbNameOffset = byteBuf.readInt();
        colNamesOffset = byteBuf.readInt();
        colTypesOffset = byteBuf.readInt();

        //process old version
        if (!old) {
            //omit pkValue(fake)
            byteBuf.readInt();
            fileNameOffset = byteBuf.readLong();
            fileOffset = byteBuf.readLong();
            if (fileNameOffset < -1 || fileOffset < -1) {
                throw new IOException("f: " + fileNameOffset + " and o: " +
                        fileOffset + " should both be signed integer");
            }
            oldColsOffset = byteBuf.readInt();
            newColsOffset = byteBuf.readInt();
        } else {
            //process new version
            fileNameOffset = byteBuf.readInt();
            fileOffset = byteBuf.readInt();
            oldColsOffset = byteBuf.readInt();
            newColsOffset = byteBuf.readInt();
            //omit pkValue(fake)
            byteBuf.readInt();
        }

        pkKeysOffset = byteBuf.readInt();
        ukColsOffset = byteBuf.readInt();

        if (brVersion > 1)
            colsEncodingOffset = byteBuf.readLong();
        //thread id& trace id
        if (brVersion == 3) {
            filterRuleValOffset = byteBuf.readInt();
            tailOffset = byteBuf.readInt();
        }

        //timestamp,process heartbeat between tx
        Type type = Type.valueOf(op);
        String ts=Long.toString(timestamp);
        if(getDbType()== DBType.OCEANBASE1){
            gloalSafeTimestamp.set(String.valueOf(fileNameOffset));
        }else {
            if (type == Type.BEGIN) {
                gloalSafeTimestamp.set(ts);
                txEnd.set(false);
            }
            if (txEnd.get() == true) {
                gloalSafeTimestamp.set(ts);
            }
            //set txEnd
            if (type == Type.COMMIT || type == Type.ROLLBACK) {
                txEnd.set(true);
            }
        }
        safeTimestamp = new String(gloalSafeTimestamp.get());
        if(isCheckCRC) {
            checkCRC();
        }
    }

    private void checkCRC() throws IOException {
        long value = getCRCValue();
        if (value == 0l) {
            return;
        }
        crc32.update(byteBuf.array(),0,byteBuf.array().length-4);
        long actual = crc32.getValue();
        crc32.reset();
        if (value != actual) {
            throw new IOException("crc 32 check failed,expect:"+value+",actual:"+actual);
        }
    }



    public String getTraceId() throws Exception {
        List<ByteString> list = BinaryMessageUtils.getByteStringList(byteBuf.array(), filterRuleValOffset);
        if(list == null || list.size() == 0 || list.size() < 3) {
            return null;
        }
        ByteString traceId=list.get(2);
        return traceId == null ? null : traceId.toString();
    }

    public String getThreadId() throws Exception {
        long threadId = 0l;
        if(tailOffset == -1) {
            return null;
        }
        List<Integer> list = BinaryMessageUtils.getArray(byteBuf.array(),(int) tailOffset);
        if(list == null || list.size() == 0) {
            return null;
        }
        threadId += (long) list.get(0);
        threadId += ((long) list.get(1)) << 8;
        threadId += ((long) list.get(2)) << 16;
        threadId += ((long) list.get(3)) << 24;
        return String.valueOf(threadId);
    }

    /**
     * �������value
     *
     * @return
     */
    public List<String> getPrimaryKeyValue() {
        try {
            if (pkValues != null) {
                return pkValues;
            }
            if (colNamesOffset < 0 || pkKeysOffset < 0) {
                return null;
            }
            pkValues = new ArrayList<String>();
            List<Integer> pks = BinaryMessageUtils.getArray(byteBuf.array(), (int) pkKeysOffset);
            List<ByteString> names = BinaryMessageUtils.getByteStringList(byteBuf.array(), colNamesOffset);
            if (pks != null) {
                for (int idx : pks) {
                    pkValues.add(names.get(idx).toString(DEFAULT_ENCODING));
                }
            }
            return pkValues;

        } catch (Exception e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getPrimaryKeys() {
        List<String> primaryKeyStringList = getPrimaryKeyValue();
        if(primaryKeyStringList != null) {
            StringBuilder pkKeyName = new StringBuilder();
            for (String idx : primaryKeyStringList) {
                if (pkKeyName.length() != 0)
                    pkKeyName.append(",");
                pkKeyName.append(idx);
            }
            return pkKeyName.toString();
        } else {
            return "";
        }
    }



    public String getUniqueColNames()  {
        try {
            if(uniqueKeyList==null) {
                if ((int) ukColsOffset < 0) {
                    uniqueKeyList = "";
                    return uniqueKeyList;
                }
                else {
                    List<Integer> uks = BinaryMessageUtils.getArray(byteBuf.array(), (int) ukColsOffset);
                    List<ByteString> names = BinaryMessageUtils.getByteStringList(byteBuf.array(), colNamesOffset);
                    StringBuilder ukKeyName = new StringBuilder();
                    if (uks != null) {
                        for (int idx : uks) {
                            if (ukKeyName.length() != 0)
                                ukKeyName.append(",");
                            ukKeyName.append(names.get(idx).toString(DEFAULT_ENCODING));
                        }
                    }
                    uniqueKeyList = ukKeyName.toString();
                    return uniqueKeyList;
                }
            }
        } catch (Exception e) {
            throw new DRCClientRunTimeException(e.getMessage(), e.getCause());
        }
        return uniqueKeyList;
    }

    public List<Long> getTimemarks() throws IOException{
        if(timeMarkOffset == -1) {
            return null;
        } else {
            //   		System.out.println("offset is " + timeMarkOffset);
            if(timeMarks == null)
                timeMarks = BinaryMessageUtils.getArray(byteBuf.array(), (int) timeMarkOffset);
            return timeMarks;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();

        builder.append("type:" + getOpt()).append(SEP);
        builder.append("record_id:" + getId()).append(SEP);
        builder.append("db:" + getDbname()).append(SEP);
        builder.append("tb:" + getTablename()).append(SEP);
        builder.append("serverId:" + getServerId()).append(SEP);
        builder.append("checkpoint:" + getCheckpoint()).append(SEP);
        builder.append("primary_value:" + getPrimaryKeys()).append(SEP);
        builder.append("unique_keys:" + getUniqueColNames()).append(SEP);
        builder.append(SEP);
        getFieldList();
        if(fields != null) {
            for (Field field : fields) {
                builder.append(field.toString());
            }
        }
        builder.append(SEP);
        return builder.toString();
    }

    private long getCRCValue()throws IOException{
        long crcValue=0l;
        if(tailOffset == -1) {
            return 0l;
        }
        List<Integer> list=BinaryMessageUtils.getArray(byteBuf.array(), (int) tailOffset);
        if(list==null||list.size()!=12){
            return 0l;
        }
        crcValue+=(long)list.get(8);
        crcValue+=((long)list.get(9))<<8;
        crcValue+=((long)list.get(10))<<16;
        crcValue+=((long)list.get(11))<<24;
        return crcValue;
    }
}
