package com.aliyun.drc.client.message.drcmessage;

import java.util.List;
import java.util.Map;

import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.message.DataMessage;

/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * use this to decode package using text format
 * the length is indicate
 * we use state machine to decode our message
 */
public class DrcNETTextRecord extends DataMessage.Record {


     public DrcNETTextRecord(List<Field> listField, Map<String, String> attr) {     
         attributes = attr;
         fields = listField;
     }

     @Override
     public void parse(final byte[] data) throws Exception {
         String stype = getAttribute("record_type");
         type = Type.valueOf(stype.toUpperCase());
         if (type == null) {
             type = Type.UNKNOWN;
         }
         //set timestamp,process heartbeat between tx
         timestamp=getAttribute("timestamp");
         if(getDbType()== DBType.OCEANBASE1){
             if(type==Type.HEARTBEAT){
                 gloalSafeTimestamp.set(timestamp);
             }else {
                 gloalSafeTimestamp.set(getCheckpoint().substring(2));
             }
         }else {
             if (type == Type.BEGIN) {
                 gloalSafeTimestamp.set(timestamp);
                 txEnd.set(false);
             }
             if (txEnd.get() == true) {
                 gloalSafeTimestamp.set(timestamp);
             }
             //set txEnd
             if (type == Type.COMMIT || type == Type.ROLLBACK) {
                 txEnd.set(true);
             }
         }
         safeTimestamp = new String(gloalSafeTimestamp.get());

         String fieldsEncodings = getAttribute("fields_enc");
         if (fieldsEncodings != null && !fieldsEncodings.isEmpty()) {
             String[] encodings = fieldsEncodings.split(",", -1);
             if (encodings.length == fields.size()) {
                 for (int i = 0; i < encodings.length; i++) {
                     String enc = encodings[i];
                     Field field = fields.get(i);
                     if (enc.isEmpty()) {
                         if (field.getType() == Field.Type.STRING) {
                             field.encoding = "binary";
                         } else if (field.getType() == Field.Type.JSON) {
                             field.encoding = UTF8MB4_ENCODING;
                         } else {
                             field.encoding = "";
                         }
                     } else {
                         if(field.getType()==Field.Type.BLOB){
                             field.type=15;
                         }
                         field.encoding = enc;
                     }
                 }
             } else if (encodings.length * 2 == fields.size()) {
                 for (int i = 0; i < encodings.length; i++) {
                     String enc = encodings[i];
                     Field field1 = fields.get(i * 2);
                     Field field2 = fields.get(i * 2 + 1);
                     if (enc.isEmpty()) {
                         if (field1.getType() == Field.Type.STRING) {
                             field1.encoding = "binary";
                             field2.encoding = "binary";
                         } else if (field1.getType() == Field.Type.JSON) {
                             field1.encoding = UTF8MB4_ENCODING;
                             field2.encoding = UTF8MB4_ENCODING;
                         } else {
                             field1.encoding = "";
                             field2.encoding = "";
                         }
                     } else {
                         if(field1.getType()==Field.Type.BLOB){
                             field1.type=15;
                             field2.type=15;
                         }
                         field1.encoding = enc;
                         field2.encoding = enc;
                     }
                 }
             }
         }
     }


}
