package com.aliyun.drc.client.message.drcmessage;

import java.io.DataInputStream;
import java.io.IOException;


public class MsgHeader {

	private int messageType;
	private int messageVersion;
	private long messageSize;
	private byte[] data;

	public void parseFrom(DataInputStream is) throws IOException {
		messageType = CIOUtil.readUnsignedShort(is);
		data = new byte[8];
		data[0] = (byte)(messageType & 0xff);
		data[1] = (byte)((messageType >> 8) & 0xff);
		messageVersion = CIOUtil.readUnsignedShort(is);
		data[2] = (byte)(messageVersion & 0xff);
		data[3] = (byte)((messageVersion >> 8) & 0xff);
		messageSize = CIOUtil.readUnsignedInt(is);
		data[4] =(byte)(messageSize & 0xff);
		data[5] =(byte)((messageSize >> 8) & 0xff);
		data[6] =(byte)((messageSize >> 16) & 0xff);
		data[7] =(byte)((messageSize >> 24) & 0xff);
	}

	public byte[] getRawData() {
		return data;
	}
	
	public int getMessageType() {
		return messageType;
	}

	public int getMessageVersion() {
		return messageVersion;
	}
	
	public long getMessageSize() {
		return messageSize;
	}
}