package com.aliyun.drc.client.message.drcmessage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.client.message.ByteString;

/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * statue machine to decode the text message
 */
public class TextDecodeStateMachine {
	public static enum DecodingMachine {
		DECONDING_VERSION,
		DECONDING_MESSAGE,
		DECODING_RECORD,
		DRCODING_FIELD,
	}
	public static enum DecodingFiledMachine {
		GETTING_NAME,
		GETTING_TYPE,
		GETTING_LENGTH,
		GETTING_VALUE,
	}
	public  class ParseResult{
		public long value;
		public boolean negative;
		public int currentOffset;
		public ParseResult() {
			value = -9999999;
			negative = false;
			currentOffset = -1;
		}
	}
	public  DecodingMachine decodingState = null;
	public static final byte LineSep = '\n';
	public static final byte AttrSep = ':';
	public static final byte NegativeFlag = '-';
	public static final byte PositiveFlag = '+';
	public static final byte EMPTY = ' ';
	public static final byte zeroValue = '0';
	public static final byte nineValue = '9'; 
	private static final String message_id = "message_id";
	private static final String message_type = "message_type";
	public String version = null;
	public TextDecodeStateMachine() {
		decodingState = DecodingMachine.DECONDING_VERSION;
		parseResult = new ParseResult();
	}
	
	
	public  ParseResult parseResult = null;
	
	//for test case
	public ParseResult getParseResult() {
		return parseResult;
	}
	
	public void parseValue(byte buff[], int offset, byte sep, ParseResult parseResult) throws Exception {
		int beginOffset = offset;
		long retValue = 0;
		boolean negative = false;
		while(buff[beginOffset] == EMPTY) {
			//truncate
			++beginOffset;
		}
		if(buff[beginOffset] == NegativeFlag) {
			negative = true;
		}else if(buff[beginOffset] == PositiveFlag) {
			negative = false;
		} else if(buff[beginOffset] < zeroValue || buff[beginOffset] > nineValue) {
			//empty case, eg: filed.type or field.lenth is " ",we will also 
			//throw exceprion in this case. 
			throw new Exception("drcnet parser inerger error");		
		} else {
			retValue = retValue * 10 + (buff[beginOffset] - zeroValue);
		}
		++beginOffset;
		while(buff[beginOffset] != LineSep) {
			if(buff[beginOffset] != EMPTY) {
				if(buff[beginOffset] < zeroValue || buff[beginOffset] > nineValue) {
					throw new Exception("drcnet parser inerger error");				
				} else {
					retValue = retValue * 10 + (buff[beginOffset] - zeroValue);
					++beginOffset;
				}
			} else {
				++beginOffset;
			}
		}
		parseResult.currentOffset = ++beginOffset;
		parseResult.negative = negative;
		parseResult.value = retValue;
	} 
	
	
	public DataMessage runStateMachine(byte buff[], DRCConfig drcConfig) throws Exception{
		DataMessage dataMessage = new DataMessage();
		int beginOffset = 0;
		int preOffset = beginOffset;
		int bufferLen = buff.length;
		int bufferEndIndex = bufferLen - 1;
		Map<String, String> arrtibute = new HashMap<String, String>();
		Map<String, String> messageAttribute = null;
		List<DataMessage.Record.Field> fieldList = null;
		String encoding = null;
		String primaryKeys = null;
		while(beginOffset < bufferLen) {
			switch(decodingState) {
			case DECONDING_VERSION: {
				//handle version
				while(buff[beginOffset] != LineSep) {
					++beginOffset;
				}
				if(beginOffset == preOffset || beginOffset - preOffset > 100) {
					throw new Exception("version should not zero or too big");
				} else {
					version = new String(buff, preOffset, beginOffset - preOffset);
					preOffset = ++beginOffset;
					decodingState = DecodingMachine.DECONDING_MESSAGE;
					break;
				}
			}
			//TODO:value is empty
			case DECONDING_MESSAGE: {
				//handle message
				//format is a:b\n , separate by ':', end with empty line \n.
				String key = null;
				String value = null;
				boolean readKey = false;
				//get all message attribute
				while(true) {
					readKey = false;
					while(buff[beginOffset] != LineSep) {
						if(buff[beginOffset] == AttrSep) {
							key = new String(buff, preOffset, beginOffset - preOffset);
							readKey = true;
							preOffset = ++beginOffset;
						} else {
							++beginOffset;
						}
					}
					if(beginOffset != preOffset) {
						//still a attribute
						value = new String(buff, preOffset, beginOffset - preOffset);
						arrtibute.put(key, value);
						preOffset = ++beginOffset;
					} else {
						if(readKey == true) {
							//attribute is null
							arrtibute.put(key, null);
							preOffset = ++beginOffset;
							continue;
						} else {
							//reach the end; jump to another state
							preOffset = ++beginOffset;
							decodingState = DecodingMachine.DECODING_RECORD;
							break;
						}
					}
				}
				break;
			}
			case DECODING_RECORD: {
				//handle record
				//format is a:b\n , separate by ':', end with empty line\n.
				String key = null;
				String value = null;
				messageAttribute = new HashMap<String, String>();
				boolean readKey = false;
				//get all message attribute
				while(true) {
					readKey = false;
					while(buff[beginOffset] != LineSep) {
                        //Bug fix: only first ':' as split character
                        if(buff[beginOffset] == AttrSep && readKey == false) {
							key = new String(buff, preOffset, beginOffset - preOffset);
							readKey = true;
							preOffset = ++beginOffset;
						} else {
							++beginOffset;
						}
					}
					if(beginOffset != preOffset) {
						//still a attribute
						value = new String(buff, preOffset, beginOffset - preOffset);
						messageAttribute.put(key, value);
						preOffset = ++beginOffset;
					} else {
						//reach the end; return the datamessage
						if(beginOffset == bufferEndIndex) {
							dataMessage.setId(Long.parseLong(arrtibute.get(message_id)));
							dataMessage.setType(Integer.parseInt(arrtibute.get(message_type)));
							decodingState = DecodingMachine.DECONDING_MESSAGE;
							return dataMessage;
						}
						preOffset = ++beginOffset;
						if(readKey == false) {							
							decodingState = DecodingMachine.DRCODING_FIELD;
							break;
						} else {
							messageAttribute.put(key, null);
							continue;
						}					
					}
				}
				break;
			}
			case DRCODING_FIELD: {
				//handle Filed
				//the filed may be NULL, it indicated the end of this message, in this case, we will check
				//if the offset has reach the end of this block
				//otherwise we will decode the filed message 
				//name\n
				//type\n
				//length\n
				//value\n
				DataMessage.Record.Field field = null;
				String name = null;
				int type = 0;
				long length = 0;
				ByteString byteString = null;
				encoding = messageAttribute.get("record_encoding");
				
				 
				String textPKs = messageAttribute.get("primary");;
	            List<String> pkList = Collections.emptyList();
	            if (textPKs != null && !textPKs.isEmpty())
	                pkList = Arrays.asList(textPKs.split(","));
				fieldList = new ArrayList<DataMessage.Record.Field>();
				while(true) {
					boolean isPrimaryKey = false;
					//read name
					while(buff[beginOffset] != LineSep) {
						++beginOffset;
					}
					if(beginOffset != preOffset) {
						name = new String(buff, preOffset, beginOffset - preOffset);
						preOffset = ++beginOffset;
					} else {
						//reach field end, do format and jump to message state
						DataMessage.Record retRecord = new DrcNETTextRecord(fieldList, messageAttribute);
						retRecord.parse(null);
                        retRecord.setRegionId(drcConfig.getRegionId());
						retRecord.setMetaMappingUtils(drcConfig.getMetaMappingUtils());
						dataMessage.addRecord(retRecord);
						preOffset = ++beginOffset;
						decodingState = DecodingMachine.DECODING_RECORD;
						break;
					}
						

					//read type
					parseValue(buff, beginOffset, LineSep, parseResult);
					type = parseResult.negative ? -((int)parseResult.value) : (int)parseResult.value;
					beginOffset = parseResult.currentOffset;
					//read length
					parseValue(buff, beginOffset, LineSep, parseResult);
					length = parseResult.negative ? -(parseResult.value) : parseResult.value;
					beginOffset = parseResult.currentOffset;
					if(length != -1) {
						byte[] valueBytes = new byte[(int) length];
						System.arraycopy(buff, beginOffset, valueBytes, 0, (int) length);
						byteString = new ByteString(valueBytes, (int)length);
						beginOffset = beginOffset + (int)length + 1;
					} else {
						byteString = null;
						beginOffset += 1;
					}
					preOffset = beginOffset;
					
					if(pkList.contains(name)) {
						isPrimaryKey = true;
					}
					
					//parse filed done
					field = new DataMessage.Record.Field(name, type, encoding, byteString, isPrimaryKey);
					fieldList.add(field);
				}
				break;
				
			}
			}
		}
		return dataMessage;
		
	}
}
