package com.aliyun.drc.client.message.drcmessage;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Header of the variable-length message storeage format
 * Version 1 storage format
 * 
 * <field-count>
 * <type of field><value of field>
 * <type of field><value of field>
 * ...
 * <type of field><value of field>
 * 
 * @author erbai.qzc
 *
 */
public class VarAreaHeader {

	private MsgHeader header;
	private long count;
	private byte[] data;

	public VarAreaHeader() {
		header = null;
		data = null;
	}

	/**
	 * Parse the VarAreaHeader from the stream.
	 * 
	 * @param is
	 * @throws IOException
	 */
	public void parseFrom(DataInputStream is) throws IOException {
		header = new MsgHeader();
		header.parseFrom(is);
		int headerLen = header.getRawData().length;
		data = new byte[headerLen + 4];
		for (int i = 0; i< headerLen; i ++) {
			data[i] = header.getRawData()[i];
		}
		count = CIOUtil.readUnsignedInt(is);
		data[headerLen] =(byte)(count & 0xff);
		data[headerLen + 1] =(byte)((count >> 8) & 0xff);
		data[headerLen + 2] =(byte)((count >> 16) & 0xff);
		data[headerLen + 3] =(byte)((count >> 24) & 0xff);
	}
	
	/**
	 * Get the message header including message type, version and size
	 * @return the message header
	 */
	public final MsgHeader getMsgHeader() {
		return header;
	}

	/**
	 * Get the count of fields
	 * 
	 * @return count
	 */
	public final long getCount() {
		return count;
	}
	
	public byte[] getRawData() {
		return data;
	}
}
