package com.aliyun.drc.utils;

import com.aliyun.drc.client.message.drcmessage.DataType;
import com.aliyun.drc.client.message.ByteString;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jianjundeng on 4/19/15.
 */
public class BinaryMessageUtils {

    private static final int PREFIX_LENGTH=12;

    /**
     * 从offset取string
     *
     * @param data byte array
     * @param offset offset
     * @param encoding encoding
     * @return string from offset
     * @throws UnsupportedEncodingException UnsupportedEncodingException
     */
    public static String getString(byte[] data,int offset, String encoding) throws UnsupportedEncodingException {
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer(data).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex(PREFIX_LENGTH + offset);
        byte t = wrapByteBuf.readByte();
        if ((t & DataType.DC_ARRAY) != 0 || (t & DataType.DC_NULL) != 0) {
            return null;
        }
        int length = (int) wrapByteBuf.readUnsignedInt();
        return new String(wrapByteBuf.array(), PREFIX_LENGTH + 5 + offset, length - 1, encoding);
    }

    /**
     * 获得offset list
     *
     * @param data byte array
     * @param offset offset
     * @return offset list
     * @throws IOException IOException
     */
    public static List getArray(byte[] data,int offset) throws IOException {
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer(data).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex(PREFIX_LENGTH + offset);
        byte t = wrapByteBuf.readByte();
        if ((t & DataType.DC_ARRAY) == 0) {
            return null;
        }
        int count = (int) wrapByteBuf.readUnsignedInt();
        if (count == 0) {
            return null;
        }
        List lists = new ArrayList(count);
        int type  = t & DataType.DT_MASK;
        for(int i = 0; i < count; i++) {
            switch(type) {
                case DataType.DT_INT8: {
                    lists.add(wrapByteBuf.readByte());
                    break;
                }
                case DataType.DT_UINT8: {
                    lists.add((int) wrapByteBuf.readUnsignedByte());
                    break;
                }
                case DataType.DT_INT16: {
                    lists.add(wrapByteBuf.readShort());
                    break;
                }
                case DataType.DT_UINT16: {
                    lists.add((int)wrapByteBuf.readUnsignedShort());
                    break;
                }
                case DataType.DT_INT32: {
                    lists.add(wrapByteBuf.readInt());
                    break;
                }
                case DataType.DT_UINT32: {
                    lists.add((long)wrapByteBuf.readUnsignedInt());
                    break;
                }
                case DataType.DT_INT64: {
                    lists.add((long)wrapByteBuf.readLong());
                    break;
                }
                case DataType.DT_UINT64: {
                    throw new IOException("Unsupported unsigned long");
                }
            }

        }
        return lists;
    }

    /**
     * 从offset处获得string list
     *
     * @param data byte array
     * @param offset offset
     * @return string list from offset
     * @throws Exception Exception
     */
    public static List<ByteString> getByteStringList(byte[] data,long offset) throws Exception {
        if(offset == -1) {
            return null;
        }
        ByteBuf wrapByteBuf = Unpooled.wrappedBuffer(data).order(ByteOrder.LITTLE_ENDIAN);
        wrapByteBuf.readerIndex((int) (PREFIX_LENGTH + offset));
        byte t = wrapByteBuf.readByte();
        if ((t & DataType.DC_ARRAY) == 0 || (t & DataType.DT_MASK) != DataType.DT_STRING) {
            throw new Exception("Data type not array or not string");
        }
        int count = wrapByteBuf.readInt();
        if (count == 0) {
            return null;
        }
        int readBytes = 5;
        readBytes += (count + 1) * 4;
        List<ByteString> lists = new ArrayList<ByteString>(count);
        int currentOffset = (int) wrapByteBuf.readUnsignedInt();
        int nextOffset;
        for (int i = 0; i < count; i++) {
            nextOffset = (int) wrapByteBuf.readUnsignedInt();
            if (nextOffset == currentOffset) {
                lists.add(null);
            } else {
                lists.add(new ByteString(wrapByteBuf.array(), PREFIX_LENGTH +
                        currentOffset + readBytes + (int) offset, nextOffset - currentOffset - 1));
            }
            currentOffset = nextOffset;
        }
        return lists;
    }
}
