package com.aliyun.drc.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.drc.client.message.DataMessage;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by haikuo.zhk on 2017/7/27.
 */
public class MetaMappingUtils {

    private JSONObject metaMappingJSON = null;

    public void init(String mappingJSONStr) {
        try {
            if(metaMappingJSON == null && StringUtils.isNotBlank(mappingJSONStr)) {
                metaMappingJSON = JSON.parseObject(mappingJSONStr);
            }
        } catch (Exception e) {
            throw new RuntimeException("init metaMappingJSON exception", e);
        }
    }

    /**
     * retrieve logical dbname by input record for drds subscription
     * @param record origin record
     * @return logical dbname
     */
    public String getLogicalDbname(DataMessage.Record record) {
        if(metaMappingJSON == null) {
            throw new RuntimeException("metaMappingJSON should not be null");
        }

        // return null if origin dbname is null or ""
        String dbname = record.getDbname();
        if(StringUtils.isBlank(dbname)) {
            return null;
        }
        String logicalDbname = null;
        JSONObject json = metaMappingJSON.getJSONObject(dbname);
        if(json != null) {
            logicalDbname = json.getString("name");
        }
        return (logicalDbname == null) ? dbname : logicalDbname;
    }

    /**
     * retrieve logical tablename by input record for drds subscription
     * @param record origin record
     * @return logical tablename
     */
    public String getLogicalTablename(DataMessage.Record record) {
        if(metaMappingJSON == null) {
            throw new RuntimeException("metaMappingJSON should not be null");
        }

        // return null if origin dbname or tablename is null or ""
        String dbname = record.getDbname();
        String tablename = record.getTablename();
        if(StringUtils.isBlank(dbname) || StringUtils.isBlank(tablename)) {
            return null;
        }

        String logicalTablename = null;
        JSONObject dbJSON = metaMappingJSON.getJSONObject(dbname);
        if(dbJSON != null) {
            JSONObject tbJSON =  dbJSON.getJSONObject("tables");
            if(tbJSON != null) {
                logicalTablename = tbJSON.getString(tablename);
            }
        }
        return (logicalTablename == null) ? tablename : logicalTablename;
    }
}
