/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message.drcmessage;

import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.message.ByteString;
import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.client.message.drcmessage.DrcNETTextRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextDecodeStateMachine {
    public DecodingMachine decodingState = DecodingMachine.DECONDING_VERSION;
    public static final byte LineSep = 10;
    public static final byte AttrSep = 58;
    public static final byte NegativeFlag = 45;
    public static final byte PositiveFlag = 43;
    public static final byte EMPTY = 32;
    public static final byte zeroValue = 48;
    public static final byte nineValue = 57;
    private static final String message_id = "message_id";
    private static final String message_type = "message_type";
    public String version = null;
    public ParseResult parseResult = new ParseResult();

    public ParseResult getParseResult() {
        return this.parseResult;
    }

    public void parseValue(byte[] buff, int offset, byte sep, ParseResult parseResult) throws Exception {
        int beginOffset = offset;
        long retValue = 0L;
        boolean negative = false;
        while (buff[beginOffset] == 32) {
            ++beginOffset;
        }
        if (buff[beginOffset] == 45) {
            negative = true;
        } else if (buff[beginOffset] == 43) {
            negative = false;
        } else {
            if (buff[beginOffset] < 48 || buff[beginOffset] > 57) {
                throw new Exception("drcnet parser inerger error");
            }
            retValue = retValue * 10L + (long)(buff[beginOffset] - 48);
        }
        ++beginOffset;
        while (buff[beginOffset] != 10) {
            if (buff[beginOffset] != 32) {
                if (buff[beginOffset] < 48 || buff[beginOffset] > 57) {
                    throw new Exception("drcnet parser inerger error");
                }
                retValue = retValue * 10L + (long)(buff[beginOffset] - 48);
                ++beginOffset;
                continue;
            }
            ++beginOffset;
        }
        parseResult.currentOffset = ++beginOffset;
        parseResult.negative = negative;
        parseResult.value = retValue;
    }

    public DataMessage runStateMachine(byte[] buff, DRCConfig drcConfig) throws Exception {
        int beginOffset;
        DataMessage dataMessage = new DataMessage();
        int preOffset = beginOffset = 0;
        int bufferLen = buff.length;
        int bufferEndIndex = bufferLen - 1;
        HashMap<String, String> arrtibute = new HashMap<String, String>();
        HashMap<String, String> messageAttribute = null;
        ArrayList<DataMessage.Record.Field> fieldList = null;
        String encoding = null;
        Object primaryKeys = null;
        while (beginOffset < bufferLen) {
            block0 : switch (this.decodingState) {
                case DECONDING_VERSION: {
                    while (buff[beginOffset] != 10) {
                        ++beginOffset;
                    }
                    if (beginOffset == preOffset || beginOffset - preOffset > 100) {
                        throw new Exception("version should not zero or too big");
                    }
                    this.version = new String(buff, preOffset, beginOffset - preOffset);
                    preOffset = ++beginOffset;
                    this.decodingState = DecodingMachine.DECONDING_MESSAGE;
                    break;
                }
                case DECONDING_MESSAGE: {
                    String key = null;
                    String value = null;
                    boolean readKey = false;
                    while (true) {
                        readKey = false;
                        while (buff[beginOffset] != 10) {
                            if (buff[beginOffset] == 58) {
                                key = new String(buff, preOffset, beginOffset - preOffset);
                                readKey = true;
                                preOffset = ++beginOffset;
                                continue;
                            }
                            ++beginOffset;
                        }
                        if (beginOffset != preOffset) {
                            value = new String(buff, preOffset, beginOffset - preOffset);
                            arrtibute.put(key, value);
                            preOffset = ++beginOffset;
                            continue;
                        }
                        if (!readKey) break;
                        arrtibute.put(key, null);
                        preOffset = ++beginOffset;
                    }
                    preOffset = ++beginOffset;
                    this.decodingState = DecodingMachine.DECODING_RECORD;
                    break;
                }
                case DECODING_RECORD: {
                    String key = null;
                    String value = null;
                    messageAttribute = new HashMap<String, String>();
                    boolean readKey = false;
                    while (true) {
                        readKey = false;
                        while (buff[beginOffset] != 10) {
                            if (buff[beginOffset] == 58 && !readKey) {
                                key = new String(buff, preOffset, beginOffset - preOffset);
                                readKey = true;
                                preOffset = ++beginOffset;
                                continue;
                            }
                            ++beginOffset;
                        }
                        if (beginOffset != preOffset) {
                            value = new String(buff, preOffset, beginOffset - preOffset);
                            messageAttribute.put(key, value);
                            preOffset = ++beginOffset;
                            continue;
                        }
                        if (beginOffset == bufferEndIndex) {
                            dataMessage.setId(Long.parseLong((String)arrtibute.get(message_id)));
                            dataMessage.setType(Integer.parseInt((String)arrtibute.get(message_type)));
                            this.decodingState = DecodingMachine.DECONDING_MESSAGE;
                            return dataMessage;
                        }
                        preOffset = ++beginOffset;
                        if (!readKey) {
                            this.decodingState = DecodingMachine.DRCODING_FIELD;
                            break block0;
                        }
                        messageAttribute.put(key, null);
                    }
                }
                case DRCODING_FIELD: {
                    DataMessage.Record.Field field = null;
                    String name = null;
                    int type = 0;
                    long length = 0L;
                    ByteString byteString = null;
                    encoding = (String)messageAttribute.get("record_encoding");
                    String textPKs = (String)messageAttribute.get("primary");
                    List<Object> pkList = Collections.emptyList();
                    if (textPKs != null && !textPKs.isEmpty()) {
                        pkList = Arrays.asList(textPKs.split(","));
                    }
                    fieldList = new ArrayList<DataMessage.Record.Field>();
                    while (true) {
                        boolean isPrimaryKey = false;
                        while (buff[beginOffset] != 10) {
                            ++beginOffset;
                        }
                        if (beginOffset == preOffset) {
                            DrcNETTextRecord retRecord = new DrcNETTextRecord(fieldList, messageAttribute);
                            ((DataMessage.Record)retRecord).parse(null);
                            retRecord.setRegionId(drcConfig.getRegionId());
                            retRecord.setMetaMappingUtils(drcConfig.getMetaMappingUtils());
                            dataMessage.addRecord(retRecord);
                            preOffset = ++beginOffset;
                            this.decodingState = DecodingMachine.DECODING_RECORD;
                            break block0;
                        }
                        name = new String(buff, preOffset, beginOffset - preOffset);
                        preOffset = ++beginOffset;
                        this.parseValue(buff, beginOffset, (byte)10, this.parseResult);
                        type = this.parseResult.negative ? -((int)this.parseResult.value) : (int)this.parseResult.value;
                        beginOffset = this.parseResult.currentOffset;
                        this.parseValue(buff, beginOffset, (byte)10, this.parseResult);
                        length = this.parseResult.negative ? -this.parseResult.value : this.parseResult.value;
                        beginOffset = this.parseResult.currentOffset;
                        if (length != -1L) {
                            byte[] valueBytes = new byte[(int)length];
                            System.arraycopy(buff, beginOffset, valueBytes, 0, (int)length);
                            byteString = new ByteString(valueBytes, (int)length);
                            beginOffset = beginOffset + (int)length + 1;
                        } else {
                            byteString = null;
                            ++beginOffset;
                        }
                        preOffset = beginOffset;
                        if (pkList.contains(name)) {
                            isPrimaryKey = true;
                        }
                        field = new DataMessage.Record.Field(name, type, encoding, byteString, isPrimaryKey);
                        fieldList.add(field);
                    }
                }
            }
        }
        return dataMessage;
    }

    public class ParseResult {
        public long value = -9999999L;
        public boolean negative = false;
        public int currentOffset = -1;
    }

    public static enum DecodingFiledMachine {
        GETTING_NAME,
        GETTING_TYPE,
        GETTING_LENGTH,
        GETTING_VALUE;

    }

    public static enum DecodingMachine {
        DECONDING_VERSION,
        DECONDING_MESSAGE,
        DECODING_RECORD,
        DRCODING_FIELD;

    }
}

