/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record.impl;

import com.aliyun.dts.subscribe.clients.common.NullableOptional;
import com.aliyun.dts.subscribe.clients.record.ForeignKeyIndexInfo;
import com.aliyun.dts.subscribe.clients.record.RecordField;
import com.aliyun.dts.subscribe.clients.record.RecordIndexInfo;
import com.aliyun.dts.subscribe.clients.record.RecordSchema;
import com.aliyun.dts.subscribe.clients.record.RowImage;
import com.aliyun.dts.subscribe.clients.record.value.Value;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultRowImage
implements RowImage {
    private final RecordSchema recordSchema;
    private final Value[] values;
    private long size;

    public DefaultRowImage(RecordSchema recordSchema) {
        this.recordSchema = recordSchema;
        this.values = new Value[recordSchema.getFieldCount()];
    }

    @Override
    public Value[] getValues() {
        return this.values;
    }

    @Override
    public Value getValue(int index) {
        return this.values[index];
    }

    @Override
    public Value getValue(RecordField field) {
        return this.getValue(field.getFieldPosition());
    }

    @Override
    public Value getValue(String fieldName) {
        NullableOptional<RecordField> recordField = this.recordSchema.getField(fieldName);
        return recordField.map(field -> this.getValue((RecordField)field)).orElse(null);
    }

    private void accumulateSize(Value value) {
        if (null != value) {
            this.size += value.size();
        }
    }

    public void setValue(int i, Value value) {
        this.values[i] = value;
        this.accumulateSize(value);
    }

    public void setValue(String fieldName, Value value) {
        RecordField recordField = this.recordSchema.getField(fieldName).orElse(null);
        this.setValue(recordField, value);
    }

    public void setValue(RecordField field, Value value) {
        int index = field.getFieldPosition();
        this.setValue(index, value);
    }

    @Override
    public Map<String, Value> toMap(Function<String, String> filedNameResolver, Function<Value, Value> valueResolver) {
        TreeMap<String, Value> valueMap = new TreeMap<String, Value>();
        int i = 0;
        for (RecordField field : this.recordSchema.getFields()) {
            valueMap.put(filedNameResolver == null ? field.getFieldName() : filedNameResolver.apply(field.getFieldName()), valueResolver == null ? this.values[i] : valueResolver.apply(this.values[i]));
            ++i;
        }
        return valueMap;
    }

    public Pair<RecordField, Value>[] buildFieldValuePairArray(Collection<RecordField> recordFields) {
        ImmutablePair[] rs = new ImmutablePair[recordFields.size()];
        int index = 0;
        for (RecordField recordField : recordFields) {
            rs[index] = Pair.of((Object)recordField, (Object)this.getValue(recordField));
        }
        return rs;
    }

    @Override
    public Pair<RecordField, Value>[] getPrimaryKeyValues() {
        RecordIndexInfo recordIndexInfo = this.recordSchema.getPrimaryIndexInfo();
        if (null == recordIndexInfo) {
            return null;
        }
        return this.buildFieldValuePairArray(recordIndexInfo.getIndexFields());
    }

    private Pair<RecordField, Value>[] buildAllFieldValuePairArray(List<? extends RecordIndexInfo> recordIndexInfoList) {
        if (null == recordIndexInfoList || recordIndexInfoList.isEmpty()) {
            return null;
        }
        Set<RecordField> recordFieldSet = recordIndexInfoList.stream().flatMap(indexInfo -> indexInfo.getIndexFields().stream()).collect(Collectors.toSet());
        return this.buildFieldValuePairArray(recordFieldSet);
    }

    @Override
    public Pair<RecordField, Value>[] getUniqueKeyValues() {
        List<RecordIndexInfo> recordIndexInfoList = this.recordSchema.getUniqueIndexInfo();
        return this.buildAllFieldValuePairArray(recordIndexInfoList);
    }

    @Override
    public Pair<RecordField, Value>[] getForeignKeyValues() {
        List<ForeignKeyIndexInfo> recordIndexInfoList = this.recordSchema.getForeignIndexInfo();
        return this.buildAllFieldValuePairArray(recordIndexInfoList);
    }

    @Override
    public long size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this.recordSchema.getFields().forEach(recordField -> sb.append("Field ").append("[").append(recordField.getFieldName()).append("]").append(" ").append("[").append(this.getValue((RecordField)recordField)).append("]").append("\n"));
        sb.append("]");
        return sb.toString();
    }
}

