package com.aliyun.drc.clusterclient;

import java.util.List;

public interface ClusterClient {
	/**
	 * Ask for GUID 设置订阅任务Guid
	 *
	 * @param guid
	 * @throws Exception
	 */
	void askForGUID(final String guid) throws Exception;

	/**
	 * 设置POP地址
	 * @param addr pop地址
	 */
	void askForCluserAddress(String addr) throws Exception;

	/**
	 * Start to launch client
	 *
	 * @throws Exception
	 */
	void start() throws Exception;

	/**
	 * Wait for limited time to stop, mainly for testing
	 *
	 * @param timelimitInSec
	 *            limited time to wait for stopped
	 * @throws InterruptedException
	 *             InterruptedException
	 */
	void waitForStop(long timelimitInSec) throws InterruptedException;

	/**
	 * Stop to launch client
	 *
	 * @throws Exception
	 *             Exception
	 */
	void stop() throws Exception;

	/**
	 * Add concurrent listener, listener consumes partition one by one
	 *
	 * @param listener
	 *            listener
	 */
	void addConcurrentListener(ClusterListener listener);

	/**
	 * Add concurrent listener using default constructor by class name
	 *
	 * @param className
	 *            className
	 * @throws InstantiationException
	 *             InstantiationException
	 * @throws IllegalAccessException
	 *             IllegalAccessException
	 * @throws ClassNotFoundException
	 *             ClassNotFoundException
	 */
	void addConcurrentListener(String className)
			throws InstantiationException, IllegalAccessException, ClassNotFoundException;

	/**
	 * Get concurrent listener list
	 *
	 * @return List for listener
	 */
	List<ClusterListener> getConcurrentListeners();
}
