package com.aliyun.drc.clusterclient;

import com.taobao.drc.clusterclient.BaseClusterContext;

import java.util.Properties;

public class ClusterContext extends BaseClusterContext {
    public static final String TAG_META_MAPPING = "meta.mapping";

    static final int DEFAULT_MAX_COUNT_OF_BUFFERED_RECORDS_NOT_ACKED = 8 * 1024;
    static final int DEFAULT_MAX_SIZE_OF_NOTIFY_MESSAGE_QUEUE = 4 * 1024;

    public ClusterContext() {
        this(new Properties());
    }

    public ClusterContext(Properties properties) {
        super(properties);
        //默认binary, drcnet关闭
        setUseDrcNet(false);
        setUseBinary(false);
        setMaxCountOfBufferedRecordsNotAcked(DEFAULT_MAX_COUNT_OF_BUFFERED_RECORDS_NOT_ACKED);
        setMaxSizeOfNotifyMessageQueue(DEFAULT_MAX_SIZE_OF_NOTIFY_MESSAGE_QUEUE);
    }

    private String dataType;

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}
