package com.aliyun.drc.clusterclient;

import com.aliyun.drc.clusterclient.impl.CloudPartitionClientFactory;
import com.aliyun.drc.clusterclient.message.ClusterMessage;
import com.aliyun.drc.regionmanager.RegionRouter;
import com.taobao.drc.clusterclient.impl.DefaultClusterClientImpl;
import com.taobao.drc.clusterclient.partition.PartitionStateChangeListener;
import com.taobao.drc.clusterclient.util.ManifestUtils;

import java.util.ArrayList;
import java.util.List;

public class DefaultClusterClient implements ClusterClient {
	private final RegionContext regionContext;// RM上下文信息
	private volatile ClusterContext clusterContext;// CM上下文信息
	private volatile String guid;
	private volatile String specailClusterAddress;// 特定RM URL，适用与指定RM地址的场景
	private final List<ClusterListener> messageListeners = new ArrayList<ClusterListener>();// message
																							// listener列表
	private final List<PartitionStateChangeListener> partitionStateChangeListeners = new ArrayList<PartitionStateChangeListener>();
	private volatile DefaultClusterClientImpl<ClusterContext, ClusterMessage, ClusterListener, CloudPartitionClientFactory> consumer;
	private volatile boolean started;

	public DefaultClusterClient(RegionContext regionContext) {
		if (regionContext == null) {
			throw new NullPointerException("DefaultClusterClient RegionContext is null");
		}
		this.regionContext = regionContext;
		this.clusterContext = null;
		this.specailClusterAddress = null;
	}

	public DefaultClusterClient(ClusterContext clusterContext) {
		if (clusterContext == null) {
			throw new NullPointerException("DefaultClusterClient ClusterContext is null");
		}
		this.regionContext = null;
		this.clusterContext = clusterContext;
		this.specailClusterAddress = null;
	}

	public void askForGUID(String guid) throws Exception {
		this.guid = guid;
	}

	/**
	 * 指定访问POP（实际访问RM）的地址
	 */
	public void askForCluserAddress(String addr) throws Exception {
		this.specailClusterAddress = addr;
	}

	public void start() throws Exception {
		synchronized (this) {
			if (started) {
				throw new IllegalStateException("The client has already been started");
			}
			if (regionContext != null) {
				// 创建 RegionRouter
				RegionRouter router = new RegionRouter();
				// 从RM 获取cluster 上下文信息
				this.clusterContext = router.getRegionRouterInfo(regionContext, guid, specailClusterAddress);
			}
			if (clusterContext.getAppGuid() == null) {
				clusterContext.setAppGuid(guid);
			}
			consumer = new DefaultClusterClientImpl<ClusterContext, ClusterMessage, ClusterListener, CloudPartitionClientFactory>(
					clusterContext, new CloudPartitionClientFactory(), messageListeners, partitionStateChangeListeners,
					ManifestUtils.getVersion(getClass()));
			consumer.start();

			started = true;
		}
	}

	public void waitForStop(long timeLimitInSec) throws InterruptedException {
		synchronized (this) {
			if (consumer != null) {
				consumer.waitForStop(timeLimitInSec);
			}
		}
	}

	public void stop() throws Exception {
		synchronized (this) {
			if (consumer != null) {
				consumer.stop();
			}
		}
	}

	public void addConcurrentListener(ClusterListener listener) {
		synchronized (this) {
			messageListeners.add(listener);
		}
	}

	public void addConcurrentListener(String className)
			throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		synchronized (this) {
			addConcurrentListener((ClusterListener) Class.forName(className).newInstance());
		}
	}

	public List<ClusterListener> getConcurrentListeners() {
		synchronized (this) {
			return messageListeners;
		}
	}
}
