package com.aliyun.drc.clusterclient;

import java.util.Properties;

/**
 * Created by jianjundeng on 6/23/15.
 */
public class RegionContext {

	private String accessKey;
	private String secret;

	private final static String serverMessageTypeTag = "server.messageType";
	private final static String useDrcNetTag = "useDrcNet";
	private boolean usePublicIp = true;// 默认使用公网IP
	private boolean useBinary = false;// true:二进制数据;false:文本数据
	private boolean useDrcNet = false;// true:drc私有网络协议；false:http协议
	private Properties properties;

	public RegionContext() {
		properties = new Properties();
		properties.put(serverMessageTypeTag, useBinary ? "binary" : "text");
		if (useDrcNet) {
			properties.put(useDrcNetTag, "true");
		}
	}

	public String getAccessKey() {
		return accessKey;
	}

	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;

	}

	public String getSecret() {
		return secret;
	}

	public void setSecret(String secret) {
		this.secret = secret;

	}

	public boolean isUsePublicIp() {
		return usePublicIp;
	}

	public void setUsePublicIp(boolean usePublicIp) {
		this.usePublicIp = usePublicIp;
	}

	public boolean isUseBinary() {
		return useBinary;
	}

	public void setUseBinary(boolean useBinary) {
		this.useBinary = useBinary;
		this.properties.put(serverMessageTypeTag, useBinary ? "binary" : "text");
	}

	public boolean isUseDrcNet() {
		return useDrcNet;
	}

	public void setUseDrcNet(boolean useDrcNet) {
		this.useDrcNet = useDrcNet;
		if (useDrcNet) {
			this.properties.setProperty(useDrcNetTag, "true");
		}
	}

	public final Properties getProperties() {
		return properties;
	}
}
