package com.aliyun.drc.clusterclient.message;

import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.clusterclient.partition.Checkpoint;
import com.aliyun.drc.clusterclient.partition.Partition;
import com.taobao.drc.clusterclient.AbstractClusterMessage;

public class ClusterMessage extends AbstractClusterMessage<DataMessage.Record, Partition, Checkpoint> {
    private final Checkpoint checkpoint;

    public ClusterMessage(DataMessage.Record record, Partition partition) {
        super(record, partition);
        this.checkpoint = new Checkpoint(record, partition);
    }

    @Override
    public Checkpoint getCheckpoint() {
        return checkpoint;
    }

    public void ackAsConsumed() {
        checkpoint.ackAsConsumed();
    }
}