package com.aliyun.drc.clusterclient.partition;

import com.aliyun.drc.client.message.DataMessage;
import com.taobao.drc.clusterclient.partition.BaseCheckpoint;
import com.taobao.drc.clusterclient.partition.IPartition;

public class Checkpoint extends BaseCheckpoint {
    public Checkpoint(DataMessage.Record record, IPartition partition) {
        super(partition);
        parseRecord(record);
    }

    public Checkpoint(String checkpoint, IPartition partition) {
        super(checkpoint, partition);
    }

    private void parseRecord(DataMessage.Record record) {
        if (record.getServerId() == null) {
            //for ob(127.0.0.1-1)
            setInstance("16843009-1");
        } else {
            setInstance(record.getServerId());
        }
        setFilePosition(record.getCheckpoint());
        setTimestamp(record.getTimestamp());
        setId(record.getId());
    }
}