package com.aliyun.drc.regionmanager;

import com.aliyun.drc.clusterclient.ClusterContext;
import com.aliyun.drc.clusterclient.RegionContext;
import com.aliyun.drc.pop.drcGuidRouteApiRequest;
import com.aliyun.drc.pop.drcGuidRouteApiResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.Charset;
import java.util.List;

import static com.aliyun.drc.utils.CipherUtils.decrypt;

/**
 * Created by jianjundeng on 6/24/15.
 */
public class RegionRouter {

	private static Logger logger = LoggerFactory.getLogger(RegionRouter.class);

	private static final int TOKEN_EXPIRE_SECOND = 60 * 10;

	public ClusterContext getRegionRouterInfo(RegionContext context, String guid) throws Exception {
		return getRegionRouterInfo(context, guid, null);
	}

	public ClusterContext getRegionRouterInfo(RegionContext context, String guid, String specailClusterAddress)
			throws Exception {
		IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", context.getAccessKey(), context.getSecret());
		if (specailClusterAddress != null && !specailClusterAddress.isEmpty()) {
			logger.debug("getRegionRouterInfo:specailClusterAddress:" + specailClusterAddress);
			DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", "Dts", specailClusterAddress);
		}

		DefaultAcsClient client = new DefaultAcsClient(profile);
		drcGuidRouteApiRequest request = new drcGuidRouteApiRequest();
		request.setguid(guid);
		drcGuidRouteApiResponse response;
		try {
			response = client.getAcsResponse(request);
		} catch (ClientException e) {
			logger.error("getAcsResponse Failed to get cluster info from POP with guid [{}], AK [{}]", guid,
					context.getAccessKey(), e);
			throw e;
		}
		if (response.getSuccess() == null || !response.getSuccess()) {
			logger.error(
					"RegionRouter Failed to get cluster info from POP with guid [{}], AK [{}], server response: [{}]",
					guid, context.getAccessKey(), response.getdata());
			throw new Exception("Failed to get cluster info from POP with guid [" + guid + "]");
		}
		String decryptResponse = decrypt(response.getdata());
		logger.debug("POP AcsResponse:[{}]", decryptResponse);
		List<NameValuePair> list = URLEncodedUtils.parse(decryptResponse, Charset.defaultCharset());
		if (list.size() < 6) {//放宽限制，只需要list.size>=6即可
			logger.error(
					"Failed to parse decrypted response from POP with GUID [{}], AK [{}], decrypted response [{}], parsed list [{}]",
					guid, context.getAccessKey(), decryptResponse, list);
			throw new Exception("Failed to decrypt response from POP with GUID [" + guid + "]");
		}
		long ts = Long.parseLong(list.get(0).getValue());
		long now = System.currentTimeMillis();
		if (ts < (now / 1000 - TOKEN_EXPIRE_SECOND)) {
			logger.error("getAcsResponse from POP with guid [{}], AK [{}]: timestamp expired [{}] < [{}],TOKEN_EXPIRE_SECOND:[{}]", guid,
					context.getAccessKey(), ts, now,TOKEN_EXPIRE_SECOND);
			throw new Exception("Timestamp expired:guid ["+guid+"]");
		}
		ClusterContext clusterContext = new ClusterContext();
		clusterContext.setAppGuid(guid);
		clusterContext.setAppGroup(list.get(1).getValue());
		clusterContext.setClusterUrl(list.get(2).getValue());
		clusterContext.setAppGroupUserName(list.get(3).getValue());
		clusterContext.setAppGroupPassword(list.get(4).getValue());
		clusterContext.setDataType(list.get(5).getValue());
		clusterContext.setUsePublicIp(context.isUsePublicIp());
		return clusterContext;
	}
}
