/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.regionmanager;

import com.aliyun.drc.clusterclient.ClusterContext;
import com.aliyun.drc.clusterclient.RegionContext;
import com.aliyun.drc.pop.drcGuidRouteApiRequest;
import com.aliyun.drc.pop.drcGuidRouteApiResponse;
import com.aliyun.drc.utils.CipherUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionRouter {
    private static Logger logger = LoggerFactory.getLogger(RegionRouter.class);
    private static final int TOKEN_EXPIRE_SECOND = 600;

    public ClusterContext getRegionRouterInfo(RegionContext context, String guid) throws Exception {
        return this.getRegionRouterInfo(context, guid, null);
    }

    public ClusterContext getRegionRouterInfo(RegionContext context, String guid, String specailClusterAddress) throws Exception {
        long now;
        drcGuidRouteApiResponse response;
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)context.getAccessKey(), (String)context.getSecret());
        if (specailClusterAddress != null && !specailClusterAddress.isEmpty()) {
            logger.debug("getRegionRouterInfo:specailClusterAddress:" + specailClusterAddress);
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Dts", (String)specailClusterAddress);
        }
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        drcGuidRouteApiRequest request = new drcGuidRouteApiRequest();
        request.setguid(guid);
        try {
            response = (drcGuidRouteApiResponse)client.getAcsResponse((AcsRequest)request);
        }
        catch (ClientException e) {
            logger.error("getAcsResponse Failed to get cluster info from POP with guid [{}], AK [{}]", new Object[]{guid, context.getAccessKey(), e});
            throw e;
        }
        if (response.getSuccess() == null || !response.getSuccess().booleanValue()) {
            logger.error("RegionRouter Failed to get cluster info from POP with guid [{}], AK [{}], server response: [{}]", new Object[]{guid, context.getAccessKey(), response.getdata()});
            throw new Exception("Failed to get cluster info from POP with guid [" + guid + "]");
        }
        String decryptResponse = CipherUtils.decrypt((String)response.getdata());
        logger.debug("POP AcsResponse:[{}]", (Object)decryptResponse);
        List list = URLEncodedUtils.parse((String)decryptResponse, (Charset)Charset.defaultCharset());
        if (list.size() < 6) {
            logger.error("Failed to parse decrypted response from POP with GUID [{}], AK [{}], decrypted response [{}], parsed list [{}]", new Object[]{guid, context.getAccessKey(), decryptResponse, list});
            throw new Exception("Failed to decrypt response from POP with GUID [" + guid + "]");
        }
        long ts = Long.parseLong(((NameValuePair)list.get(0)).getValue());
        if (ts < (now = System.currentTimeMillis()) / 1000L - 600L) {
            logger.error("getAcsResponse from POP with guid [{}], AK [{}]: timestamp expired [{}] < [{}],TOKEN_EXPIRE_SECOND:[{}],need check local machine time", new Object[]{guid, context.getAccessKey(), ts, now, 600});
            throw new Exception("Timestamp expired:guid [" + guid + "]");
        }
        ClusterContext clusterContext = new ClusterContext();
        clusterContext.setAppGuid(guid);
        clusterContext.setAppGroup(((NameValuePair)list.get(1)).getValue());
        clusterContext.setClusterUrl(((NameValuePair)list.get(2)).getValue());
        clusterContext.setAppGroupUserName(((NameValuePair)list.get(3)).getValue());
        clusterContext.setAppGroupPassword(((NameValuePair)list.get(4)).getValue());
        clusterContext.setDataType(((NameValuePair)list.get(5)).getValue());
        clusterContext.setUsePublicIp(context.isUsePublicIp());
        clusterContext.setUseBinary(context.isUseBinary());
        clusterContext.setUseDrcNet(context.isUseDrcNet());
        clusterContext.setMaxRetryTimes(context.getMaxRetryTimes());
        return clusterContext;
    }
}

