/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.clusterclient.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.drc.client.DRCClient;
import com.aliyun.drc.client.DRCClientFactory;
import com.aliyun.drc.client.DataFilter;
import com.aliyun.drc.client.DataFilterBase;
import com.aliyun.drc.client.Listener;
import com.aliyun.drc.client.impl.Checkpoint;
import com.aliyun.drc.clusterclient.ClusterContext;
import com.aliyun.drc.clusterclient.impl.CloudClientListenerAdapter;
import com.aliyun.drc.clusterclient.message.ClusterMessage;
import com.aliyun.drc.clusterclient.partition.CloudPartitionImpl;
import com.taobao.drc.clusterclient.MessageNotifier;
import com.taobao.drc.clusterclient.NotifyController;
import com.taobao.drc.clusterclient.PartitionClient;
import com.taobao.drc.clusterclient.clustermanager.PartitionInfo;
import com.taobao.drc.clusterclient.partition.IPartition;
import com.taobao.drc.clusterclient.util.Time;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPartitionClient
implements PartitionClient<com.aliyun.drc.clusterclient.partition.Checkpoint> {
    private static final Logger logger = LoggerFactory.getLogger(CloudPartitionClient.class);
    private final ClusterContext context;
    private final PartitionInfo partitionInfo;
    private final MessageNotifier<ClusterMessage> notifier;
    private final String initOffset;
    private final NotifyController<ClusterMessage> notifyController;
    private final CloudPartitionImpl partition;
    private final DRCClient client;
    private Thread clientThread;
    private String filterDbTable;

    public CloudPartitionClient(ClusterContext context, PartitionInfo partitionInfo, MessageNotifier<ClusterMessage> notifier, String initOffset, String filterDbTable) throws Exception {
        this.context = context;
        this.partitionInfo = partitionInfo;
        this.notifier = notifier;
        this.initOffset = initOffset;
        this.notifyController = new NotifyController(Time.SYSTEM);
        this.partition = new CloudPartitionImpl(context, partitionInfo);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)context.getProperties());
        if (partitionInfo.getTables() != null && !partitionInfo.getTables().isEmpty()) {
            properties.setProperty("meta.mapping", JSON.toJSONString((Object)partitionInfo.getTables(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField}));
        }
        this.client = DRCClientFactory.create((DRCClientFactory.Type)DRCClientFactory.Type.MYSQL, (Object)properties);
        this.filterDbTable = filterDbTable;
        this.initClient();
    }

    private void initClient() throws Exception {
        if (this.context.isUsePublicIp()) {
            this.client.usePublicIp();
        }
        this.client.addDataFilter(this.parseDataFilter());
        this.client.addListener((Listener)new CloudClientListenerAdapter(this.partition, this.notifyController, this.notifier, this.context.getDataType()));
        this.client.initService(this.context.getAppGroupUserName(), this.partitionInfo.getTopic(), this.context.getAppGroupPassword(), this.parseCheckpoint(this.initOffset), null);
    }

    private Checkpoint parseCheckpoint(String offset) {
        com.aliyun.drc.clusterclient.partition.Checkpoint checkpoint = new com.aliyun.drc.clusterclient.partition.Checkpoint(offset, (IPartition)this.partition);
        Checkpoint drcClientCheckpoint = new Checkpoint();
        if (checkpoint.getInstance() != null) {
            drcClientCheckpoint.setServerId(checkpoint.getInstance());
        }
        if (checkpoint.getFilePosition() != null) {
            drcClientCheckpoint.setPosition(checkpoint.getFilePosition());
        }
        if (checkpoint.getTimestamp() != null) {
            drcClientCheckpoint.setTimestamp(checkpoint.getTimestamp());
        }
        if (checkpoint.getId() != null) {
            drcClientCheckpoint.setRecordId(checkpoint.getId());
        }
        return drcClientCheckpoint;
    }

    private DataFilterBase parseDataFilter() {
        if (StringUtils.isNotEmpty((CharSequence)this.filterDbTable)) {
            return new DataFilter(this.filterDbTable);
        }
        String filterStr = this.partitionInfo.makeFilterString();
        logger.info("CloudPartitionClient Filter for partition [{}][{}][{}]: [{}]", new Object[]{this.context.getAppGuid(), this.context.getAppGroup(), this.partitionInfo.getPartition(), filterStr});
        return new DataFilter(filterStr);
    }

    public void start() throws IOException {
        if (this.clientThread != null) {
            throw new IllegalStateException("Client for partition [" + this.partitionInfo + "] has already started");
        }
        try {
            this.clientThread = this.client.startService();
            this.clientThread.setName("DTS-DRCClient-" + this.partition.getName() + "-Thread");
            this.clientThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread arg0, Throwable arg1) {
                    logger.error(arg0.getName() + ", " + arg1.toString());
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isActive() {
        return this.clientThread != null && this.clientThread.isAlive();
    }

    public String offset() {
        com.aliyun.drc.clusterclient.partition.Checkpoint checkpoint;
        if (this.client != null && (checkpoint = (com.aliyun.drc.clusterclient.partition.Checkpoint)this.partition.getCheckpoint()) != null) {
            return checkpoint.toString();
        }
        return null;
    }

    public NotifyController getNotifyController() {
        return this.notifyController;
    }

    public IPartition<com.aliyun.drc.clusterclient.partition.Checkpoint> getPartition() {
        return this.partition;
    }

    public void close() throws IOException {
        if (this.clientThread == null) {
            return;
        }
        try {
            this.client.stopService();
            this.clientThread.join();
        }
        catch (IOException e) {
            logger.error("Failed to stop client", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to stop client", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public Map<String, Object> getMetrics() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.putAll(this.partition.getMetrics());
        map.putAll(this.notifyController.getMetrics());
        return map;
    }
}

