/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.common;

import apsara.odps.lot.ExpressionProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.ScalarExpression;
import java.util.ArrayList;
import java.util.List;

public class WindowFunction {
    private String project;
    private String name;
    private List<ScalarExpression> parameters;
    private List<ScalarExpression> partitionBy;
    private List<Order> sortBy;
    private WindowingClause windowing;
    private boolean distinct;

    public WindowFunction(String project, String name, List<ScalarExpression> parameters, List<ScalarExpression> partitionBy, boolean isDistinct) {
        if (project == null) {
            throw new ArgumentNullException("project");
        }
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (partitionBy == null) {
            throw new ArgumentNullException("partitionBy");
        }
        if (partitionBy.size() == 0) {
            throw new IllegalArgumentException("You have to specify one item at least in 'partitionBy' parameter.");
        }
        this.parameters = parameters == null ? new ArrayList<ScalarExpression>() : parameters;
        this.project = project;
        this.name = name;
        this.partitionBy = partitionBy;
        this.distinct = isDistinct;
    }

    public String getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public List<ScalarExpression> getParameters() {
        return this.parameters;
    }

    public List<ScalarExpression> getPartitionBy() {
        return this.partitionBy;
    }

    public List<Order> getSortBy() {
        return this.sortBy;
    }

    public WindowingClause getWindowing() {
        return this.windowing;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setSortBy(List<Order> sortBy) {
        if (sortBy == null) {
            throw new ArgumentNullException("sortBy");
        }
        this.sortBy = sortBy;
    }

    public void setWindowing(WindowingClause windowing) {
        if (windowing == null) {
            throw new ArgumentNullException("windowing");
        }
        this.windowing = windowing;
    }

    public ExpressionProtos.WindowFunction toProtoBuf() {
        ExpressionProtos.WindowFunction.Builder builder = ExpressionProtos.WindowFunction.newBuilder();
        builder.setProject(this.project);
        builder.setName(this.name);
        builder.setIsDistinct(this.distinct);
        for (ScalarExpression param : this.parameters) {
            builder.addParameters(param.toProtoBuf());
        }
        for (ScalarExpression pb : this.partitionBy) {
            builder.addPartitionBy(pb.toProtoBuf());
        }
        if (this.sortBy != null && this.sortBy.size() > 0) {
            for (Order order : this.sortBy) {
                builder.addOrderBy(order.toProtoBuf());
            }
        }
        if (this.windowing != null) {
            builder.setWindowingClause(this.windowing.toProtoBuf());
        }
        return builder.build();
    }

    public static class Order {
        private ScalarExpression expression;
        private boolean asc = true;

        public void setAsc(boolean asc) {
            this.asc = asc;
        }

        public ScalarExpression getExpression() {
            return this.expression;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public Order(ScalarExpression expression, boolean asc) {
            if (expression == null) {
                throw new ArgumentNullException("expression");
            }
            this.expression = expression;
            this.asc = asc;
        }

        public Order(ScalarExpression expression) {
            if (expression == null) {
                throw new ArgumentNullException("expression");
            }
            this.expression = expression;
        }

        public ExpressionProtos.WindowFunction.OrderBy toProtoBuf() {
            ExpressionProtos.WindowFunction.OrderBy.Builder builder = ExpressionProtos.WindowFunction.OrderBy.newBuilder();
            builder.setExpression(this.expression.toProtoBuf());
            builder.setIsAsc(this.asc);
            return builder.build();
        }
    }

    public static class WindowingClause {
        private int preceding;
        private int following;

        public int getPreceding() {
            return this.preceding;
        }

        public int getFollowing() {
            return this.following;
        }

        public WindowingClause(int preceding, int following) {
            this.preceding = preceding;
            this.following = following;
        }

        public ExpressionProtos.WindowFunction.WindowingClause toProtoBuf() {
            ExpressionProtos.WindowFunction.WindowingClause.Builder builder = ExpressionProtos.WindowFunction.WindowingClause.newBuilder();
            builder.setBegin(this.preceding);
            builder.setEnd(this.following);
            return builder.build();
        }
    }
}

