/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.test;

import com.aliyun.odps.Odps;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class OdpsTestUtils {
    private static final Properties props = new Properties();
    private static SimpleDateFormat df;

    public static Properties loadConfig() throws IOException {
        InputStream is = null;
        try {
            is = OdpsTestUtils.class.getClassLoader().getResourceAsStream("test.conf");
            props.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return props;
    }

    public static Odps newDefaultOdps() {
        Odps odps = null;
        String accessId = props.getProperty("default.access.id");
        String accessKey = props.getProperty("default.access.key");
        String endpoint = props.getProperty("default.endpoint");
        String project = props.getProperty("default.project");
        AliyunAccount account = new AliyunAccount(accessId, accessKey);
        odps = new Odps((Account)account);
        odps.setDefaultProject(project);
        odps.setEndpoint(endpoint);
        return odps;
    }

    public static synchronized String currentTime() {
        return df.format(new Date());
    }

    public static String getProperty(String name) {
        return props.getProperty(name);
    }

    public static void cleanup() {
    }

    public static boolean checkBoolean(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value.trim());
    }

    public static Odps newHttpsOdps() {
        Odps odps = OdpsTestUtils.newDefaultOdps();
        odps.setEndpoint(props.getProperty("https.endpoint"));
        return odps;
    }

    static {
        try {
            OdpsTestUtils.loadConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    }
}

