/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.client.ResourceClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.behavior_collection.BehaviorCollectionService;
import com.aliyun.opensearch.sdk.generated.behavior_collection.Command;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import java.util.Map;

public class BehaviorCollectionClient
implements BehaviorCollectionService.Iface {
    private static final Integer SEARCH_DOC_CLICK_EVENT_ID = 2001;
    private static final String SEARCH_DOC_SDK_TYPE = "opensearch_sdk";
    private static final String SEARCH_DOC_SDK_VERSION = "v3.3.0";
    private ResourceClient resourceClient;
    private JSONArray recordBuffer = new JSONArray();

    public BehaviorCollectionClient(OpenSearchClient client) {
        this.resourceClient = new ResourceClient("/app-groups", client);
    }

    public void addSearchDocClickRecord(String searchDocListPage, String docDetailPage, Integer detailPageStayTime, String objectId, String opsRequestMisc, Map<String, String> basicFields) {
        JSONObject jsonFields = new JSONObject();
        jsonFields.put("event_id", SEARCH_DOC_CLICK_EVENT_ID);
        jsonFields.put("sdk_type", SEARCH_DOC_SDK_TYPE);
        jsonFields.put("sdk_version", SEARCH_DOC_SDK_VERSION);
        jsonFields.put("page", docDetailPage);
        jsonFields.put("arg1", searchDocListPage);
        jsonFields.put("arg2", "");
        jsonFields.put("arg3", detailPageStayTime);
        jsonFields.put("args", this.createSearchDocClickArgs(objectId, opsRequestMisc));
        if (basicFields != null && !basicFields.isEmpty()) {
            for (Map.Entry<String, String> entry : basicFields.entrySet()) {
                jsonFields.put(entry.getKey(), entry.getValue());
            }
        }
        this.addOneRecord(jsonFields, Command.ADD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchResult commit(String searchAppName, String behaviorCollectionName) throws OpenSearchException, OpenSearchClientException {
        OpenSearchResult result;
        try {
            result = this.doPush(this.recordBuffer, searchAppName, behaviorCollectionName);
        }
        finally {
            this.recordBuffer = new JSONArray();
        }
        return result;
    }

    @Override
    public OpenSearchResult push(String recordsJson, String searchAppName, String behaviorCollectionName) throws OpenSearchException, OpenSearchClientException {
        JSONArray recordsJsonArray = new JSONArray(recordsJson);
        return this.doPush(recordsJsonArray, searchAppName, behaviorCollectionName);
    }

    private OpenSearchResult doPush(JSONArray recordsJsonArray, String searchAppName, String behaviorCollectionName) throws OpenSearchException, OpenSearchClientException {
        return this.resourceClient.post(this.createPushPath(searchAppName, behaviorCollectionName), recordsJsonArray.toString());
    }

    private void addOneRecord(JSONObject jsonFields, Command cmd) {
        JSONObject jsonRecord = new JSONObject();
        jsonRecord.put("fields", jsonFields);
        jsonRecord.put("cmd", cmd.toString());
        this.recordBuffer.put(jsonRecord);
    }

    private String createPushPath(String searchAppName, String behaviorCollectionName) {
        return String.format("/%s/data-collections/%s/actions/bulk", searchAppName, behaviorCollectionName);
    }

    private String createSearchDocClickArgs(String objectId, String opsRequestMisc) {
        return String.format("object_id=%s,object_type=ops_search_doc,ops_request_misc=%s", objectId, opsRequestMisc);
    }
}

