/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.client.ResourceClient;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.quota.Quota;
import com.aliyun.opensearch.sdk.generated.quota.QuotaService;
import com.aliyun.opensearch.util.JsonUtilWrapper;

public class QuotaClient
implements QuotaService.Iface {
    private ResourceClient resourceClient;

    public QuotaClient(OpenSearchClient client) {
        this.resourceClient = new ResourceClient("/quotas", client);
    }

    @Override
    public OpenSearchResult getByAppIdentity(String appIdentity) throws OpenSearchException, OpenSearchClientException {
        return this.doGet(appIdentity);
    }

    @Override
    public OpenSearchResult updateByAppIdentity(String appIdentity, Quota quota) throws OpenSearchException, OpenSearchClientException {
        return this.doUpdate(appIdentity, quota);
    }

    private OpenSearchResult doGet(String identity) throws OpenSearchException, OpenSearchClientException {
        return this.resourceClient.get(this.createResourcePath(identity));
    }

    private OpenSearchResult doUpdate(String identity, Quota quota) throws OpenSearchException, OpenSearchClientException {
        return this.resourceClient.patch(this.createResourcePath(identity), JsonUtilWrapper.toJson(quota));
    }

    private String createResourcePath(String identity) {
        return String.format("%s", identity);
    }
}

