/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.search.general.SearchResult;
import com.aliyun.opensearch.sdk.generated.suggestion.ReSearch;
import com.aliyun.opensearch.sdk.generated.suggestion.SuggestParams;
import com.aliyun.opensearch.sdk.generated.suggestion.SuggestionService;
import com.aliyun.opensearch.suggest.UrlParamsBuilder;
import com.aliyun.opensearch.util.Utils;
import java.util.Map;

public class SuggestionClient
implements SuggestionService.Iface {
    private static final String SUGGESTION_API_PATH = "/apps/{appName}/suggest/{suggestionName}/search";
    private OpenSearchClient client;
    private String appName;
    private String suggestionName;
    private String query = "";
    private byte hits = (byte)10;
    private String userId;
    private ReSearch reSearch;

    public SuggestionClient(String appName, String suggestionName, OpenSearchClient client) {
        this.appName = appName;
        this.suggestionName = suggestionName;
        this.client = client;
    }

    public SuggestionClient setQuery(String query) {
        this.query = query;
        return this;
    }

    public SuggestionClient setHits(byte hits) {
        this.hits = hits;
        return this;
    }

    public SuggestionClient setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public SuggestionClient setReSearch(ReSearch reSearch) {
        this.reSearch = reSearch;
        return this;
    }

    @Override
    @Deprecated
    public String search() throws OpenSearchException, OpenSearchClientException {
        SuggestParams suggestParams = new SuggestParams();
        suggestParams.setQuery(this.query);
        suggestParams.setHits(this.hits);
        if (this.userId != null) {
            suggestParams.setUserId(this.userId);
        }
        if (this.reSearch != null) {
            suggestParams.setReSearch(this.reSearch);
        }
        UrlParamsBuilder urlParamsBuilder = new UrlParamsBuilder(suggestParams);
        Map<String, String> params = Utils.toMap(urlParamsBuilder.getHttpParams());
        return this.doGet(this.parseApiPathTemplate(), params);
    }

    @Override
    public SearchResult execute(SuggestParams suggestParams) throws OpenSearchException, OpenSearchClientException {
        UrlParamsBuilder urlParamsBuilder = new UrlParamsBuilder(suggestParams);
        Map<String, String> params = Utils.toMap(urlParamsBuilder.getHttpParams());
        String requestPath = this.parseApiPathTemplate();
        String response = this.client.call(requestPath, params, "GET");
        return new SearchResult(response);
    }

    private String doGet(String requestPath, Map<String, String> params) throws OpenSearchClientException {
        return this.client.call(requestPath, params, "GET");
    }

    private String parseApiPathTemplate() {
        return SUGGESTION_API_PATH.replace("{appName}", this.appName).replace("{suggestionName}", this.suggestionName);
    }
}

