/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.auth;

import com.aliyun.opensearch.auth.Authentication;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.annotations.VisibleForTesting;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Joiner;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Preconditions;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Maps;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.hash.Hashing;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.io.BaseEncoding;
import com.aliyun.opensearch.util.Utils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchAuthentication
implements Authentication {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchAuthentication.class);
    private String baseURI;
    private String accessKey;
    private String secret;
    private String securityToken = null;
    private static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public OpenSearchAuthentication(String baseURI, String accessKey, String secret) {
        this.baseURI = baseURI;
        this.accessKey = accessKey;
        this.secret = secret;
    }

    public OpenSearchAuthentication(String baseURI, String accessKey, String secret, String securityToken) {
        this(baseURI, accessKey, secret);
        this.securityToken = securityToken;
    }

    @Override
    public TreeMap<String, String> createOpenSearchHeaders(long expireTime) {
        TreeMap<String, String> opensearch_headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        opensearch_headers.put("X-Opensearch-Nonce", OpenSearchAuthentication.getNonce());
        if (expireTime > 0L) {
            opensearch_headers.put("X-Opensearch-Expire", String.valueOf(expireTime));
        }
        if (this.securityToken != null) {
            opensearch_headers.put("X-Opensearch-Security-Token", this.securityToken);
        }
        return opensearch_headers;
    }

    @Override
    public TreeMap<String, Object> createSignParameters(String method, String request_path, TreeMap<String, String> opensearch_headers, Map<String, String> params) {
        TreeMap<String, String> sortedQueryParameters = OpenSearchAuthentication.sortParametersByKey(params);
        TreeMap<String, Object> signParameters = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        String content_md5 = "";
        signParameters.put("method", method);
        signParameters.put("request_path", request_path);
        signParameters.put("content_md5", content_md5);
        signParameters.put("content_type", "application/json; charset=utf-8");
        signParameters.put("date", OpenSearchAuthentication.formatIso8601Date(new Date()));
        signParameters.put("opensearch_headers", opensearch_headers);
        signParameters.put("query_params", sortedQueryParameters);
        if (!method.equals("GET") && params != null && !params.isEmpty()) {
            String body = params.get("_POST_BODY");
            LOG.debug("BODY_CONTENT: ", (Object)body);
            signParameters.put("content_md5", Hashing.md5().hashString(body, Charset.forName("UTF-8")).toString());
        }
        return signParameters;
    }

    @Override
    public String createAliyunSign(TreeMap<String, Object> sortMap) {
        String method = (String)sortMap.get("method");
        String content_md5 = (String)sortMap.get("content_md5");
        String content_type = (String)sortMap.get("content_type");
        String date = (String)sortMap.get("date");
        String request_path = (String)sortMap.get("request_path");
        TreeMap<String, String> query_params = OpenSearchAuthentication.paramsFilter(OpenSearchAuthentication.get_query_params((TreeMap)sortMap.get("query_params")));
        TreeMap<String, String> opensearch_headers = OpenSearchAuthentication.paramsFilter((TreeMap)sortMap.get("opensearch_headers"));
        String string_to_sign = OpenSearchAuthentication.createToSignContents(method, content_md5, content_type, date, opensearch_headers, request_path, query_params);
        LOG.debug("\n---------Content to sign: ----------\n", (Object)string_to_sign, (Object)"\n------------------------------------");
        String signature = OpenSearchAuthentication.signature(string_to_sign, this.secret);
        LOG.debug("signature: ", (Object)signature);
        return signature;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    protected static String createToSignContents(String method, String content_md5, String content_type, String date, TreeMap<String, String> opensearch_headers, String request_path, TreeMap<String, String> query_params) {
        void var11_16;
        StringBuilder string_to_sign = new StringBuilder();
        string_to_sign.append(method.toUpperCase()).append("\n");
        string_to_sign.append(content_md5).append("\n");
        string_to_sign.append(content_type).append("\n");
        string_to_sign.append(date).append("\n");
        for (Map.Entry<String, String> entry : opensearch_headers.entrySet()) {
            String header_key = entry.getKey().toLowerCase();
            String string = entry.getValue();
            string_to_sign.append(header_key).append(":").append(string).append("\n");
        }
        String signable_resource = Utils.percentEncode(request_path).replaceAll("%2F", "/");
        LinkedList<String> query_params_kvs = Lists.newLinkedList();
        for (Map.Entry entry : query_params.entrySet()) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            String encodeKey = Utils.percentEncode(k);
            String encodeValue = Utils.percentEncode(v);
            StringBuilder s = new StringBuilder();
            query_params_kvs.add(s.append(encodeKey).append("=").append(encodeValue).toString());
        }
        String query_params_string = Joiner.on('&').join(query_params_kvs);
        String string = signable_resource;
        if (!query_params_string.isEmpty()) {
            String string2 = string + "?" + query_params_string;
        }
        string_to_sign.append((String)var11_16);
        return string_to_sign.toString();
    }

    @Override
    public Map<String, String> createHttpHeaders(TreeMap<String, String> opensearch_headers, TreeMap<String, Object> signParameters, String signature) {
        LinkedHashMap<String, String> headers = Maps.newLinkedHashMap();
        headers.putAll(opensearch_headers);
        headers.put("Content-Type", (String)signParameters.get("content_type"));
        headers.put("Date", (String)signParameters.get("date"));
        headers.put("Accept-Language", "zh-cn");
        headers.put("Content-Md5", (String)signParameters.get("content_md5"));
        String authorization = "OPENSEARCH " + this.accessKey + ":" + signature;
        headers.put("Authorization", authorization);
        return headers;
    }

    private static TreeMap<String, String> sortParametersByKey(Map<String, String> params) {
        TreeMap<String, String> sortedParameters = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        if (params != null) {
            sortedParameters.putAll(params);
            sortedParameters.remove("_POST_BODY");
        }
        return sortedParameters;
    }

    @VisibleForTesting
    protected static String signature(String toSignContent, String secret) {
        byte[] text;
        Mac mac;
        byte[] keyBytes;
        Preconditions.checkNotNull(secret);
        try {
            keyBytes = secret.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM NOT SUPPORT UTF-8?");
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "HmacSHA1");
        try {
            mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new RuntimeException("JVM NOT SUPPORT Algorithm: HmacSHA1?");
        }
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException e1) {
            throw new RuntimeException(e1);
        }
        try {
            text = toSignContent.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM NOT SUPPORT UTF-8?");
        }
        return BaseEncoding.base64().encode(mac.doFinal(text));
    }

    private static TreeMap<String, String> paramsFilter(TreeMap<String, String> params) {
        if (params.containsKey("Signature")) {
            params.remove("Signature");
        }
        LinkedList<String> emptyValueKeys = new LinkedList<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!"".equals(value)) continue;
            emptyValueKeys.add(key);
        }
        for (String key : emptyValueKeys) {
            params.remove(key);
        }
        return params;
    }

    private static TreeMap<String, String> get_query_params(TreeMap<String, String> object) {
        if (null == object) {
            return new TreeMap<String, String>();
        }
        return object;
    }

    private static String getNonce() {
        long timestamp = System.nanoTime();
        int randInt = Utils.randInt(10000, 99999999);
        return "" + timestamp + randInt;
    }

    private static String formatIso8601Date(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATE_FORMAT);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }
}

