/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.client;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClient {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceClient.class);
    private OpenSearchClient openSearchClient;
    private String baseURI;

    public ResourceClient(String baseURI, OpenSearchClient openSearchClient) {
        this.openSearchClient = openSearchClient;
        this.baseURI = baseURI;
    }

    public OpenSearchResult post(String path, String body) throws OpenSearchException, OpenSearchClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isEmpty(body)) {
            params.put("_POST_BODY", body);
        }
        String uri = this.baseURI;
        if (!StringUtils.isEmpty(path)) {
            uri = uri + path;
        }
        return this.call(uri, params, "POST");
    }

    public OpenSearchResult put(String path, String body) throws OpenSearchException, OpenSearchClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isEmpty(body)) {
            params.put("_POST_BODY", body);
        }
        String uri = this.baseURI;
        if (!StringUtils.isEmpty(path)) {
            uri = uri + path;
        }
        return this.call(uri, params, "PUT");
    }

    public OpenSearchResult get(String path) throws OpenSearchException, OpenSearchClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        return this.get(path, params);
    }

    public OpenSearchResult get(String path, Map<String, String> params) throws OpenSearchException, OpenSearchClientException {
        String uri = !StringUtils.isEmpty(path) ? String.format("%s/%s", this.baseURI, path) : this.baseURI;
        return this.call(uri, params, "GET");
    }

    public OpenSearchResult delete(String path) throws OpenSearchException, OpenSearchClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        String uri = String.format("%s/%s", this.baseURI, path);
        return this.call(uri, params, "DELETE");
    }

    public OpenSearchResult patch(String path, String body) throws OpenSearchException, OpenSearchClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("_POST_BODY", body);
        String uri = String.format("%s/%s", this.baseURI, path);
        return this.call(uri, params, "PATCH");
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    private OpenSearchResult call(String path, Map<String, String> params, String method) throws OpenSearchClientException, OpenSearchException {
        return this.openSearchClient.callAndDecodeResult(path, params, method);
    }
}

