/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.search;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Joiner;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Optional;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Preconditions;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import com.aliyun.opensearch.sdk.generated.search.Aggregate;
import com.aliyun.opensearch.sdk.generated.search.Config;
import com.aliyun.opensearch.sdk.generated.search.Distinct;
import com.aliyun.opensearch.sdk.generated.search.FinalDistinct;
import com.aliyun.opensearch.sdk.generated.search.FinalDistinctKey;
import com.aliyun.opensearch.sdk.generated.search.Order;
import com.aliyun.opensearch.sdk.generated.search.Rank;
import com.aliyun.opensearch.sdk.generated.search.SearchFormat;
import com.aliyun.opensearch.sdk.generated.search.SearchParams;
import com.aliyun.opensearch.sdk.generated.search.Sort;
import com.aliyun.opensearch.sdk.generated.search.SortField;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractSubClausesBuilder {
    public static final String ConfigClauseKey = "config";
    public static final String QueryClauseKey = "query";
    public static final String SortClauseKey = "sort";
    public static final String DistinctClauseKey = "distinct";
    public static final String AggregateClauseKey = "aggregate";
    public static final String FilterClauseKey = "filter";
    public static final String KVpairsClause = "kvpairs";
    public static final String FinalDistinctClauseKey = "final_distinct";
    protected SearchParams params;

    public AbstractSubClausesBuilder(SearchParams params) {
        this.params = params;
    }

    Optional<String> buildConfigClause() {
        return Optional.absent();
    }

    Optional<String> buildQueryClause() {
        return Optional.absent();
    }

    Optional<String> buildSortClause() {
        return Optional.absent();
    }

    Optional<String> buildFilterClause() {
        return Optional.absent();
    }

    Optional<String> buildDistinctClause() {
        return Optional.absent();
    }

    Optional<String> buildAggregateClause() {
        return Optional.absent();
    }

    Optional<String> buildKVpairsClause() {
        return Optional.absent();
    }

    Optional<String> buildFinalDistinctClause() {
        return Optional.absent();
    }

    Optional<String> buildCustomClauses() {
        return Optional.absent();
    }

    public String getClausesString() {
        LinkedList<String> clauses = Lists.newLinkedList();
        clauses.add(this.buildConfigClause().orNull());
        clauses.add(this.buildQueryClause().orNull());
        clauses.add(this.buildSortClause().orNull());
        clauses.add(this.buildFilterClause().orNull());
        clauses.add(this.buildDistinctClause().orNull());
        clauses.add(this.buildAggregateClause().orNull());
        clauses.add(this.buildKVpairsClause().orNull());
        clauses.add(this.buildFinalDistinctClause().orNull());
        clauses.add(this.buildCustomClauses().orNull());
        return Joiner.on("&&").skipNulls().join(clauses);
    }

    final Optional<String> getDefaultConfigClause() {
        StringBuilder queryClause = new StringBuilder(ConfigClauseKey).append("=");
        ArrayList<String> configClauses = Lists.newArrayList();
        Config config = this.params.getConfig();
        Rank rank = this.params.getRank();
        int start = config.getStart();
        AbstractSubClausesBuilder.append(configClauses, "start", ":", start);
        int hits = config.getHits();
        AbstractSubClausesBuilder.append(configClauses, "hit", ":", hits);
        int rerank_size = rank.getReRankSize();
        AbstractSubClausesBuilder.append(configClauses, "rerank_size", ":", rerank_size);
        SearchFormat searchFormat = config.getSearchFormat();
        AbstractSubClausesBuilder.append(configClauses, "format", ":", searchFormat.name().toLowerCase());
        if (config.isSetCustomConfig()) {
            configClauses.add(Joiner.on(",").join(config.getCustomConfig()));
        }
        return Optional.of(queryClause.append(Joiner.on(",").join(configClauses)).toString());
    }

    final Optional<String> getDefaulQueryClause() {
        StringBuilder queryClause = new StringBuilder(QueryClauseKey).append("=");
        String queryString = Optional.fromNullable(this.params.getQuery()).or("''");
        return Optional.of(queryClause.append(queryString).toString());
    }

    final Optional<String> getDefaultSortClause() {
        Sort sort;
        Optional<String> sortClause = Optional.absent();
        if (this.params.isSetSort() && (sort = this.params.getSort()).isSetSortFields()) {
            StringBuilder sortBuilder = new StringBuilder(SortClauseKey).append("=");
            List<SortField> sortFields = sort.getSortFields();
            ArrayList<String> sortStrings = Lists.newArrayList();
            for (SortField sortField : sortFields) {
                String order;
                String field = sortField.getField();
                Order orderEnum = sortField.getOrder();
                switch (orderEnum) {
                    case INCREASE: {
                        order = "+";
                        break;
                    }
                    case DECREASE: {
                        order = "-";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknow order: " + orderEnum);
                    }
                }
                sortStrings.add(order + field);
            }
            sortClause = Optional.of(sortBuilder.append(Joiner.on(";").join(sortStrings)).toString());
        }
        return sortClause;
    }

    Optional<String> getDefaultAggregateClause() {
        return this.buildKVSetClause(this.params.isSetAggregates(), AggregateClauseKey, this.params.getAggregates(), new OptionalStringListCreator<Aggregate>(){

            @Override
            public List<String> create(Aggregate target) {
                return AbstractSubClausesBuilder.createListOfAggregateStrings(target);
            }
        });
    }

    <T> Optional<String> buildKVSetClause(boolean isSet, String keyName, Set<T> targets, OptionalStringListCreator<T> listCreator) {
        Optional<String> clauseOptional = Optional.absent();
        if (isSet) {
            StringBuilder clauseString = new StringBuilder(keyName).append("=");
            LinkedList<String> listOfClauseString = Lists.newLinkedList();
            for (T target : targets) {
                List<String> strings = listCreator.create(target);
                listOfClauseString.add(Joiner.on(",").join(strings));
            }
            if (!listOfClauseString.isEmpty()) {
                clauseString.append(Joiner.on(";").join(listOfClauseString));
                clauseOptional = Optional.of(clauseString.toString());
            }
        }
        return clauseOptional;
    }

    Optional<String> getDefaultDistinctClause() {
        return this.buildKVSetClause(this.params.isSetDistincts(), DistinctClauseKey, this.params.getDistincts(), new OptionalStringListCreator<Distinct>(){

            @Override
            public List<String> create(Distinct target) {
                return AbstractSubClausesBuilder.createListOfDistinctStrings(target);
            }
        });
    }

    final Optional<String> getDefaultFilterClause() {
        Optional<String> filterClause = Optional.absent();
        if (this.params.isSetFilter()) {
            filterClause = Optional.of(AbstractSubClausesBuilder.concat(FilterClauseKey, "=", this.params.getFilter()));
        }
        return filterClause;
    }

    final Optional<String> getDefaultKVpairsClause() {
        Optional<String> kVpairsClause = Optional.absent();
        Config config = this.params.getConfig();
        if (config.isSetKvpairs()) {
            kVpairsClause = Optional.of(AbstractSubClausesBuilder.concat(KVpairsClause, "=", config.getKvpairs()));
        }
        return kVpairsClause;
    }

    Optional<String> getDefaultFinalDistinctClause() {
        if (!this.params.isSetFinalDistinct()) {
            return Optional.absent();
        }
        FinalDistinct finalDistinct = this.params.getFinalDistinct();
        ArrayList<String> kvPairs = Lists.newArrayList();
        AbstractSubClausesBuilder.append(kvPairs, "dist_type", ":", finalDistinct.getType().name().toLowerCase());
        ArrayList<String> distKeyList = Lists.newArrayList();
        ArrayList<String> distCountList = Lists.newArrayList();
        for (FinalDistinctKey key : finalDistinct.getKeyList()) {
            distKeyList.add(key.getKey());
            distCountList.add(String.valueOf(key.getCount()));
        }
        String distKey = Joiner.on(";").join(distKeyList);
        String distCount = Joiner.on(";").join(distCountList);
        AbstractSubClausesBuilder.append(kvPairs, "dist_key", ":", distKey);
        AbstractSubClausesBuilder.append(kvPairs, "dist_count", ":", distCount);
        if (finalDistinct.isSetSort()) {
            String distSort = Joiner.on(";").join(finalDistinct.getSort());
            AbstractSubClausesBuilder.append(kvPairs, "dist_sort", ":", distSort);
        }
        if (finalDistinct.isSetSpecialCount()) {
            ArrayList specialCountList = Lists.newArrayList();
            for (Map.Entry<String, Integer> entry : finalDistinct.getSpecialCount().entrySet()) {
                StringBuilder specialCountBuilder = new StringBuilder();
                specialCountBuilder.append(entry.getKey());
                specialCountBuilder.append("@");
                specialCountBuilder.append(entry.getValue());
                specialCountList.add(specialCountBuilder.toString());
            }
            String string = Joiner.on("|").join(specialCountList);
            AbstractSubClausesBuilder.append(kvPairs, "dist_special_count", ":", string);
        }
        if (finalDistinct.isSetCustomFinalDistinct()) {
            for (Map.Entry entry : finalDistinct.getCustomFinalDistinct().entrySet()) {
                AbstractSubClausesBuilder.append(kvPairs, (String)entry.getKey(), ":", entry.getValue());
            }
        }
        StringBuilder queryClause = new StringBuilder(FinalDistinctClauseKey).append("=");
        return Optional.of(queryClause.append(Joiner.on(",").join(kvPairs)).toString());
    }

    Optional<String> getDefaultCustomClauses() {
        if (!this.params.isSetCustomClause()) {
            return Optional.absent();
        }
        ArrayList<String> clauses = Lists.newArrayList();
        for (Map.Entry<String, String> entry : this.params.getCustomClause().entrySet()) {
            AbstractSubClausesBuilder.append(clauses, entry.getKey(), "=", entry.getValue());
        }
        return Optional.of(Joiner.on("&&").join(clauses));
    }

    protected static List<String> createListOfAggregateStrings(Aggregate aggregate) {
        String groupKey = Preconditions.checkNotNull(aggregate.getGroupKey(), "groupKey is required.");
        String aggFun = aggregate.getAggFun();
        String range = aggregate.getRange();
        String maxGroup = aggregate.getMaxGroup();
        String aggFilter = aggregate.getAggFilter();
        String aggSamplerThresHold = aggregate.getAggSamplerThresHold();
        String aggSamplerStep = aggregate.getAggSamplerStep();
        LinkedList<String> aggregateString = Lists.newLinkedList();
        AbstractSubClausesBuilder.append(aggregateString, "group_key", ":", groupKey);
        AbstractSubClausesBuilder.append(aggregateString, "agg_fun", ":", aggFun);
        AbstractSubClausesBuilder.append(aggregateString, "range", ":", range);
        AbstractSubClausesBuilder.append(aggregateString, "max_group", ":", maxGroup);
        AbstractSubClausesBuilder.append(aggregateString, "agg_filter", ":", aggFilter);
        AbstractSubClausesBuilder.append(aggregateString, "agg_sampler_threshold", ":", aggSamplerThresHold);
        AbstractSubClausesBuilder.append(aggregateString, "agg_sampler_step", ":", aggSamplerStep);
        return aggregateString;
    }

    protected static List<String> createListOfDistinctStrings(Distinct distinct) {
        String key = Preconditions.checkNotNull(distinct.getKey(), "key is required.");
        int distCount = distinct.getDistCount();
        int distTimes = distinct.getDistTimes();
        boolean reserved = distinct.isReserved();
        String distFilter = distinct.getDistFilter();
        boolean updateTotalHit = distinct.isUpdateTotalHit();
        String grade = distinct.getGrade();
        LinkedList<String> distinctString = Lists.newLinkedList();
        AbstractSubClausesBuilder.append(distinctString, "dist_key", ":", key);
        AbstractSubClausesBuilder.append(distinctString, "dist_count", ":", distCount);
        AbstractSubClausesBuilder.append(distinctString, "dist_times", ":", distTimes);
        AbstractSubClausesBuilder.append(distinctString, "reserved", ":", reserved);
        AbstractSubClausesBuilder.append(distinctString, "dist_filter", ":", distFilter);
        AbstractSubClausesBuilder.append(distinctString, "update_total_hit", ":", updateTotalHit);
        AbstractSubClausesBuilder.append(distinctString, "grade", ":", grade);
        return distinctString;
    }

    private static void append(List<String> stringlist, String key, String splitter, Object value) {
        if (null != value) {
            stringlist.add(AbstractSubClausesBuilder.concat(key.trim(), splitter, value));
        }
    }

    private static String concat(String key, String splitter, Object value) {
        Preconditions.checkNotNull(key, "key was null.");
        return key.trim() + splitter + value;
    }

    static interface OptionalStringListCreator<T> {
        public List<String> create(T var1);
    }
}

