/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.search;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Preconditions;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Maps;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Sets;
import com.aliyun.opensearch.sdk.generated.search.Config;
import com.aliyun.opensearch.sdk.generated.search.Distinct;
import com.aliyun.opensearch.sdk.generated.search.SearchParams;
import com.aliyun.opensearch.sdk.generated.search.Summary;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SearchParamsBuilder {
    private SearchParams searchParams;

    public static SearchParamsBuilder create(Config config) {
        return new SearchParamsBuilder(config);
    }

    public static SearchParamsBuilder create(SearchParams otherSearchParams) {
        return new SearchParamsBuilder(otherSearchParams);
    }

    private SearchParamsBuilder(Config config) {
        this.searchParams = new SearchParams(config);
    }

    private SearchParamsBuilder(SearchParams otherSearchParams) {
        this.searchParams = otherSearchParams;
    }

    public SearchParamsBuilder addCustomParam(String key, String value) {
        Map<Object, Object> customParam;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        if (this.searchParams.isSetCustomParam()) {
            customParam = this.searchParams.getCustomParam();
            Preconditions.checkArgument(!customParam.containsKey(key), "the CustomParam is already added. key: " + key);
        } else {
            customParam = Maps.newHashMap();
        }
        customParam.put(key, value);
        this.searchParams.setCustomParam(customParam);
        return this;
    }

    public SearchParamsBuilder addFilter(String filter, String operator) {
        if (operator == null) {
            operator = "AND";
        }
        if (this.searchParams.isSetFilter()) {
            String f = this.searchParams.getFilter();
            filter = f + " " + operator + " " + filter;
        }
        this.searchParams.setFilter(filter);
        return this;
    }

    public SearchParamsBuilder addFilter(String filter) {
        this.addFilter(filter, "AND");
        return this;
    }

    public SearchParamsBuilder addSummary(String fieldName, Integer len, String element, String ellipsis, Integer snippet) {
        if (fieldName == null || fieldName.equals("")) {
            return this;
        }
        LinkedHashMap<String, Summary> summariesMap = Maps.newLinkedHashMap();
        if (this.searchParams.isSetSummaries()) {
            Set<Summary> _summaries = this.searchParams.getSummaries();
            for (Summary summary : _summaries) {
                summariesMap.put(summary.getSummary_field(), summary);
            }
            Preconditions.checkArgument(!summariesMap.containsKey(fieldName), "the Summaries is already added. fieldName: " + fieldName);
        } else {
            summariesMap.put(fieldName, new Summary(fieldName));
        }
        this.searchParams.setSummaries(Sets.newLinkedHashSet(summariesMap.values()));
        return this;
    }

    public SearchParamsBuilder addDisableFunction(String functionName, String value) {
        Map<Object, Object> disableFunctions;
        Preconditions.checkNotNull(functionName, "functionName should not be null.");
        Preconditions.checkNotNull(value, "value should not be null.");
        if (this.searchParams.isSetDisableFunctions()) {
            disableFunctions = this.searchParams.getDisableFunctions();
            Preconditions.checkArgument(!disableFunctions.containsKey(functionName), "the DisableFunction is already added. functionName: " + functionName);
        } else {
            disableFunctions = Maps.newLinkedHashMap();
        }
        disableFunctions.put(functionName, value);
        this.searchParams.setDisableFunctions(disableFunctions);
        return this;
    }

    public SearchParamsBuilder addDistinct(String key, int distCount, int distTimes, boolean reserved, String distFilter, boolean updateTotalHit, double grade) {
        Preconditions.checkNotNull(key, "key should not be null.");
        LinkedHashMap<String, Distinct> distincts = Maps.newLinkedHashMap();
        if (this.searchParams.isSetDistincts()) {
            Set<Distinct> distinctsSet = this.searchParams.getDistincts();
            for (Distinct distinct : distinctsSet) {
                distincts.put(distinct.getKey(), distinct);
            }
            Preconditions.checkArgument(!distincts.containsKey(key), "the Distinct is already added. key: " + key);
        }
        Distinct distinct = new Distinct(key);
        distinct.setDistCount(distCount);
        distinct.setDistTimes(distTimes);
        distinct.setReserved(reserved);
        distinct.setDistFilter(distFilter);
        distinct.setUpdateTotalHit(updateTotalHit);
        distinct.setGrade(Double.toString(grade));
        distincts.put(key, distinct);
        this.searchParams.setDistincts(Sets.newLinkedHashSet(distincts.values()));
        return this;
    }

    public String toString() {
        return "SearchParamsBuilder [" + this.searchParams + "]";
    }

    public SearchParams build() {
        return this.searchParams;
    }
}

