/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.search;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Joiner;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Preconditions;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.params.BasicHttpParams;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.params.SyncBasicHttpParams;
import com.aliyun.opensearch.sdk.generated.search.DeepPaging;
import com.aliyun.opensearch.sdk.generated.search.Rank;
import com.aliyun.opensearch.sdk.generated.search.SearchFormat;
import com.aliyun.opensearch.sdk.generated.search.SearchParams;
import com.aliyun.opensearch.sdk.generated.search.Summary;
import com.aliyun.opensearch.search.AbstractSubClausesBuilder;
import com.aliyun.opensearch.search.ScrollingSubClausesBuilder;
import com.aliyun.opensearch.search.SearchingSubClausesBuilder;
import com.aliyun.opensearch.search.SuggestSubClausesBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UrlParamsBuilder {
    private static final String QUERY = "query";
    private static final String FORMAT = "format";
    private static final String FIRST_RANK_NAME = "first_rank_name";
    private static final String SECOND_RANK_NAME = "second_rank_name";
    private static final String SECOND_RANK_TYPE = "second_rank_type";
    private static final String SUMMARY = "summary";
    private static final String FETCH_FIELDS = "fetch_fields";
    private static final String QP = "qp";
    private static final String DISABLE = "disable";
    private static final String PROTOBUF = "protobuf";
    private static final String ROUTE_VALUE = "route_value";
    private static final String SCROLL_EXPIRE = "scroll";
    private static final String SCROLL_ID = "scroll_id";
    private static final String SEARCH_TYPE = "search_type";
    private static final String VALUE_SPLITTER_FETCHFIELDS = ";";
    private static final String VALUE_SPLITTER_QP = ";";
    private static final String VALUE_SPLITTER_DISABLEFUNCTIONS = ";";
    private static final String VALUE_SPLITTER_DISABLEFUNCTIONS_KEYVALUE = ":";
    private static final String SEARCH_TYPE_SCAN = "scan";
    private static final String ABTEST = "abtest";
    private SyncBasicHttpParams httpParams = new SyncBasicHttpParams();

    public UrlParamsBuilder(SearchParams searchParams) {
        this();
        this.init(searchParams);
    }

    public UrlParamsBuilder() {
    }

    private void init(SearchParams searchParams) {
        this.initQuery(searchParams);
        this.initScroll(searchParams);
        this.initRank(searchParams);
        this.initSuggest(searchParams);
        this.initFormat(searchParams);
        this.initFetchFields(searchParams);
        this.initSummary(searchParams);
        this.initRouteValue(searchParams);
        this.initCustomParams(searchParams);
        this.initQueryProcessorNames(searchParams);
        this.initDisableFunctions(searchParams);
        this.initAbtest(searchParams);
        this.initUserId(searchParams);
        this.initRawQuery(searchParams);
    }

    private void initSuggest(SearchParams searchParams) {
        if (searchParams.isSetSuggest()) {
            this.setCustomParam("hit", Integer.toString(searchParams.getConfig().getHits()));
        }
    }

    private void initRank(SearchParams searchParams) {
        this.initFirstRankName(searchParams);
        this.initSecondRankName(searchParams);
        this.initSecondRankType(searchParams);
    }

    private void initScroll(SearchParams searchParams) {
        if (searchParams.isSetDeepPaging()) {
            this.setSearchType(SEARCH_TYPE_SCAN);
            DeepPaging deepPaging = searchParams.getDeepPaging();
            this.setScrollExpire(deepPaging.getScrollExpire());
            this.setScrollId(deepPaging.getScrollId());
        }
    }

    private void initFormat(SearchParams searchParams) {
        SearchFormat format = searchParams.getConfig().getSearchFormat();
        Preconditions.checkArgument(null != format, "SearchFormat not specified.");
        this.setFormat(format.toString().toLowerCase());
    }

    private void initQuery(SearchParams searchParams) {
        AbstractSubClausesBuilder subClausesBuilder = searchParams.isSetDeepPaging() ? new ScrollingSubClausesBuilder(searchParams) : (searchParams.isSetSuggest() ? new SuggestSubClausesBuilder(searchParams) : new SearchingSubClausesBuilder(searchParams));
        this.setQuery(subClausesBuilder.getClausesString());
    }

    private void initFirstRankName(SearchParams searchParams) {
        Rank rank;
        if (searchParams.isSetRank() && (rank = searchParams.getRank()).isSetFirstRankName()) {
            this.setFirstRankName(rank.getFirstRankName());
        }
    }

    private void initSecondRankName(SearchParams searchParams) {
        Rank rank;
        if (searchParams.isSetRank() && (rank = searchParams.getRank()).isSetSecondRankName()) {
            this.setSecondRankName(rank.getSecondRankName());
        }
    }

    private void initSecondRankType(SearchParams searchParams) {
        Rank rank;
        if (searchParams.isSetRank() && (rank = searchParams.getRank()).isSetSecondRankType()) {
            this.setSecondRankType(rank.getSecondRankType().toString().toLowerCase());
        }
    }

    void initFetchFields(SearchParams searchParams) {
        if (searchParams.getConfig().isSetFetchFields()) {
            List<String> fetchFields = searchParams.getConfig().getFetchFields();
            this.setFetchFields(Joiner.on(";").join(fetchFields));
        }
    }

    void initQueryProcessorNames(SearchParams searchParams) {
        if (searchParams.isSetQueryProcessorNames()) {
            this.setQueryProcessorNames(Joiner.on(";").join(searchParams.getQueryProcessorNames()));
        }
    }

    void initDisableFunctions(SearchParams searchParams) {
        if (searchParams.isSetDisableFunctions()) {
            Map<String, String> disableFunctions = searchParams.getDisableFunctions();
            this.setDisableFunctions(Joiner.on(";").withKeyValueSeparator(VALUE_SPLITTER_DISABLEFUNCTIONS_KEYVALUE).join(disableFunctions));
        }
    }

    private void initSummary(SearchParams searchParams) {
        if (searchParams.isSetSummaries()) {
            Set<Summary> summaries = searchParams.getSummaries();
            LinkedList<String> summariesStrings = Lists.newLinkedList();
            for (Summary summary : summaries) {
                LinkedList<String> summaryStrings = Lists.newLinkedList();
                Set<Summary._Fields> summaryFieldsSet = Summary.metaDataMap.keySet();
                for (Summary._Fields _Fields2 : summaryFieldsSet) {
                    Object fieldValue = summary.getFieldValue(_Fields2);
                    if (null == fieldValue) continue;
                    summaryStrings.add(_Fields2.getFieldName() + VALUE_SPLITTER_DISABLEFUNCTIONS_KEYVALUE + fieldValue);
                }
                summariesStrings.add(Joiner.on(",").join(summaryStrings));
            }
            this.setSummary(Joiner.on(";").join(summariesStrings));
        }
    }

    private void initAbtest(SearchParams searchParams) {
        if (searchParams.isSetAbtest()) {
            ArrayList<String> abtestParams = new ArrayList<String>();
            if (searchParams.getAbtest().isSetSceneTag()) {
                abtestParams.add(String.format("%s:%s", "scene_tag", searchParams.getAbtest().getSceneTag()));
            }
            if (searchParams.getAbtest().isSetFlowDivider()) {
                abtestParams.add(String.format("%s:%s", "flow_divider", searchParams.getAbtest().getFlowDivider()));
            }
            if (!abtestParams.isEmpty()) {
                this.setAbtest(StringUtils.join(abtestParams, ","));
            }
        }
    }

    private void initUserId(SearchParams searchParams) {
        if (searchParams.isSetUserId()) {
            this.setUserId(searchParams.getUserId());
        }
    }

    private void initRawQuery(SearchParams searchParams) {
        if (searchParams.isSetRawQuery()) {
            this.setRawQuery(searchParams.getRawQuery());
        }
    }

    private void initRouteValue(SearchParams searchParams) {
        if (searchParams.getConfig().isSetRouteValue()) {
            this.setRouteValue(searchParams.getConfig().getRouteValue());
        }
    }

    private void initCustomParams(SearchParams searchParams) {
        if (searchParams.isSetCustomParam()) {
            Map<String, String> customParam = searchParams.getCustomParam();
            for (Map.Entry<String, String> entry : customParam.entrySet()) {
                this.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
    }

    public BasicHttpParams getHttpParams() {
        return this.httpParams;
    }

    public void setQuery(String queryParamValue) {
        this.httpParams.setParameter(QUERY, queryParamValue);
    }

    public void setFormat(String formatParamValue) {
        this.httpParams.setParameter(FORMAT, formatParamValue);
    }

    public void setFirstRankName(String firstRankNameParamValue) {
        this.httpParams.setParameter(FIRST_RANK_NAME, firstRankNameParamValue);
    }

    public void setSecondRankName(String secondRankNameParamValue) {
        this.httpParams.setParameter(SECOND_RANK_NAME, secondRankNameParamValue);
    }

    public void setSecondRankType(String secondRankTypeParamValue) {
        this.httpParams.setParameter(SECOND_RANK_TYPE, secondRankTypeParamValue);
    }

    public void setSummary(String summaryParamValue) {
        this.httpParams.setParameter(SUMMARY, summaryParamValue);
    }

    public void setAbtest(String abtestParamValue) {
        this.httpParams.setParameter(ABTEST, abtestParamValue);
    }

    public void setUserId(String userId) {
        this.httpParams.setParameter("user_id", userId);
    }

    public void setRawQuery(String rawQuery) {
        this.httpParams.setParameter("raw_query", rawQuery);
    }

    public void setFetchFields(String fetchFieldsParamValue) {
        this.httpParams.setParameter(FETCH_FIELDS, fetchFieldsParamValue);
    }

    public void setQueryProcessorNames(String queryProcessorNamesParamValue) {
        this.httpParams.setParameter(QP, queryProcessorNamesParamValue);
    }

    public void setDisableFunctions(String disableFunctionsParamValue) {
        this.httpParams.setParameter(DISABLE, disableFunctionsParamValue);
    }

    public void setRouteValue(String routeValue) {
        this.httpParams.setParameter(ROUTE_VALUE, routeValue);
    }

    public void setScrollExpire(String scrollExpireValue) {
        this.httpParams.setParameter(SCROLL_EXPIRE, scrollExpireValue);
    }

    public void setScrollId(String scrollIdValue) {
        this.httpParams.setParameter(SCROLL_ID, scrollIdValue);
    }

    public void setSearchType(String searchTypeValue) {
        this.httpParams.setParameter(SEARCH_TYPE, searchTypeValue);
    }

    public void setCustomParam(String key, String value) {
        this.httpParams.setParameter(key, value);
    }

    public String toString() {
        BasicHttpParams httpParams = this.getHttpParams();
        Set<String> names = httpParams.getNames();
        StringBuilder b = new StringBuilder();
        for (String name : names) {
            b.append(StringUtils.rightPad(name, 15, " ") + "=" + httpParams.getParameter(name)).append("\n");
        }
        return b.toString();
    }

    static interface QueryUrlParamBuilder {
        public String build(SearchParams var1);
    }
}

