/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.suggest;

import com.aliyun.opensearch.sdk.dependencies.org.apache.http.params.BasicHttpParams;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.params.SyncBasicHttpParams;
import com.aliyun.opensearch.sdk.generated.suggestion.ReSearch;
import com.aliyun.opensearch.sdk.generated.suggestion.SuggestParams;
import java.util.Map;

public class UrlParamsBuilder {
    private SyncBasicHttpParams httpParams = new SyncBasicHttpParams();

    public UrlParamsBuilder() {
    }

    public UrlParamsBuilder(SuggestParams suggestParams) {
        this();
        this.init(suggestParams);
    }

    public void setQuery(String query) {
        this.httpParams.setParameter("query", query);
    }

    public void setHits(int hits) {
        this.httpParams.setParameter("hit", hits);
    }

    public void setUserId(String userId) {
        this.httpParams.setParameter("user_id", userId);
    }

    public void setReSearch(ReSearch reSearchType) {
        if (reSearchType == null) {
            return;
        }
        String value = reSearchType.toString().toLowerCase();
        this.httpParams.setParameter("re_search", value);
    }

    public void setCustomParam(String key, String value) {
        this.httpParams.setParameter(key, value);
    }

    public BasicHttpParams getHttpParams() {
        return this.httpParams;
    }

    private void init(SuggestParams suggestParams) {
        this.initQuery(suggestParams);
        this.initHits(suggestParams);
        this.initUserId(suggestParams);
        this.initReSearch(suggestParams);
        this.initCustomParams(suggestParams);
    }

    private void initQuery(SuggestParams suggestParams) {
        if (!suggestParams.isSetQuery()) {
            return;
        }
        this.setQuery(suggestParams.getQuery());
    }

    private void initHits(SuggestParams suggestParams) {
        if (!suggestParams.isSetHits()) {
            return;
        }
        this.setHits(suggestParams.getHits());
    }

    private void initUserId(SuggestParams suggestParams) {
        if (!suggestParams.isSetUserId()) {
            return;
        }
        this.setUserId(suggestParams.getUserId());
    }

    private void initReSearch(SuggestParams suggestParams) {
        if (!suggestParams.isSetReSearch()) {
            return;
        }
        this.setReSearch(suggestParams.getReSearch());
    }

    private void initCustomParams(SuggestParams suggestParams) {
        if (suggestParams.isSetCustomParams()) {
            Map<String, String> customParams = suggestParams.getCustomParams();
            for (Map.Entry<String, String> entry : customParams.entrySet()) {
                this.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
    }
}

