/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.util;

import com.aliyun.opensearch.sdk.dependencies.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.aliyun.opensearch.tracer.ClientTracer;
import com.aliyun.opensearch.util.HttpClientFactory;
import com.aliyun.opensearch.util.HttpResult;
import java.io.IOException;
import java.util.Map;

public class HttpClientManager {
    private HttpClientFactory httpClientFactory = new HttpClientFactory(0, 0, 0);

    public void setClientTracer(ClientTracer clientTracer) {
        this.httpClientFactory.setClientTracer(clientTracer);
    }

    public ClientTracer getClientTracer() {
        return this.httpClientFactory.getClientTracer();
    }

    public PoolingClientConnectionManager getConnectionManager() {
        return this.httpClientFactory.connectionManager;
    }

    public void setMaxConnections(int maxConnections) {
        if (maxConnections > 0 && maxConnections != this.httpClientFactory.getMaxConnections()) {
            if (this.httpClientFactory != null) {
                this.httpClientFactory.shutdownIdleConnectionMonitor();
            }
            this.httpClientFactory = new HttpClientFactory(0, 0, maxConnections);
        }
    }

    public void setTimeout(int timeout) {
        this.httpClientFactory.setTimeOut(timeout);
    }

    public void enableGzip() {
        this.httpClientFactory.enableGzip();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.httpClientFactory.setConnectTimeout(connectTimeout);
    }

    public HttpResult doPost(String requestPath, Map<String, String> headers, String body, String encoding) throws IOException {
        return this.httpClientFactory.doPost(requestPath, headers, body, encoding);
    }

    public HttpResult doPatch(String requestPath, Map<String, String> headers, String body, String encoding) throws IOException {
        return this.httpClientFactory.doPatch(requestPath, headers, body, encoding);
    }

    public HttpResult doDelete(String requestPath, Map<String, String> headers, String encoding) throws IOException {
        return this.httpClientFactory.doDelete(requestPath, headers, encoding);
    }

    public HttpResult doGet(String url, Map<String, String> headers, String encoding, boolean isPB) throws IOException {
        return this.httpClientFactory.doGet(url, headers, encoding, isPB);
    }

    public HttpResult doPut(String requestPath, Map<String, String> headers, String body, String encoding) throws IOException {
        return this.httpClientFactory.doPut(requestPath, headers, body, encoding);
    }
}

