/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.Chart;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class Dashboard
implements Serializable {
    private static final long serialVersionUID = 3152635375534266524L;
    private String dashboardName = "";
    private String description = "";
    private String displayName = "";
    private ArrayList<Chart> chartList = new ArrayList();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDashboardName() {
        return this.dashboardName;
    }

    public void setDashboardName(String dashboardName) {
        this.dashboardName = dashboardName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<Chart> getChartList() {
        return this.chartList;
    }

    public void setChartList(ArrayList<Chart> chartList) {
        this.chartList = new ArrayList();
        for (Chart chart : chartList) {
            this.chartList.add(chart);
        }
    }

    public Dashboard() {
    }

    public Dashboard(String dashboardName, String description, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
    }

    public Dashboard(String dashboardName, String displayName, String description, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
        this.displayName = displayName;
    }

    public JSONObject ToJsonObject() {
        JSONObject dashboardJson = new JSONObject();
        dashboardJson.put((Object)"dashboardName", (Object)this.getDashboardName());
        dashboardJson.put((Object)"description", (Object)this.getDescription());
        dashboardJson.put((Object)"displayName", (Object)this.getDisplayName());
        JSONArray chartArray = new JSONArray();
        for (Chart chart : this.getChartList()) {
            chartArray.add((Object)chart.ToJsonObject());
        }
        dashboardJson.put((Object)"charts", (Object)chartArray);
        return dashboardJson;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.setDashboardName(dict.getString("dashboardName"));
            this.setDescription(dict.getString("description"));
            if (dict.has("displayName")) {
                this.setDisplayName(dict.getString("displayName"));
            }
            ArrayList<Chart> chartList = new ArrayList<Chart>();
            try {
                JSONArray chartJsonArray = dict.getJSONArray("charts");
                for (int index = 0; index != chartJsonArray.size(); ++index) {
                    Chart chart = new Chart();
                    chart.FromJsonObject(chartJsonArray.getJSONObject(index));
                    chartList.add(chart);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.setChartList(chartList);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateDashboard", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String dashboardString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)dashboardString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateDashboard", e.getMessage(), e, "");
        }
    }
}

