/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.LoggingDetail;
import com.aliyun.openservices.log.util.Args;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class Logging
implements Serializable {
    private String loggingProject;
    private List<LoggingDetail> loggingDetails;

    public Logging(String loggingProject, List<LoggingDetail> loggingDetails) {
        this.setLoggingProject(loggingProject);
        this.setLoggingDetails(loggingDetails);
    }

    public String getLoggingProject() {
        return this.loggingProject;
    }

    public void setLoggingProject(String loggingProject) {
        Args.notNullOrEmpty(loggingProject, "loggingProject");
        this.loggingProject = loggingProject;
    }

    public List<LoggingDetail> getLoggingDetails() {
        return this.loggingDetails;
    }

    public void setLoggingDetails(List<LoggingDetail> loggingDetails) {
        Args.notNullOrEmpty(loggingDetails, "loggingDetails");
        this.loggingDetails = new ArrayList<LoggingDetail>(loggingDetails);
    }

    public void addLoggingDetail(LoggingDetail loggingDetail) {
        Args.notNull(loggingDetail, "loggingDetail");
        this.loggingDetails.add(loggingDetail);
    }

    public JSONObject marshal() {
        JSONObject object = new JSONObject();
        object.put((Object)"loggingProject", (Object)this.loggingProject);
        JSONArray details = new JSONArray();
        for (LoggingDetail detail : this.loggingDetails) {
            details.add((Object)detail.marshal());
        }
        object.put((Object)"loggingDetails", (Object)details);
        return object;
    }

    public static Logging unmarshal(JSONObject object) {
        Args.notNull(object, "object");
        String project = object.getString("loggingProject");
        Args.notNullOrEmpty(project, "loggingProject");
        JSONArray details = object.getJSONArray("loggingDetails");
        Args.notNullOrEmpty((Collection)details, "loggingDetails");
        ArrayList<LoggingDetail> loggingDetails = new ArrayList<LoggingDetail>(details.size());
        for (int i = 0; i < details.size(); ++i) {
            loggingDetails.add(LoggingDetail.unmarshal(details.getJSONObject(i)));
        }
        return new Logging(project, loggingDetails);
    }
}

