/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.comm;

import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.comm.RepeatableInputStreamEntity;
import com.aliyun.openservices.log.http.comm.ServiceClient;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

class HttpFactory {
    HttpFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        ThreadSafeClientConnManager connMgr = this.createThreadSafeClientConnManager(config);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connMgr, (HttpParams)httpParams);
        if (System.getProperty("com.aliyun.openservices.disableCertChecking") != null) {
            Scheme sch = new Scheme("https", 443, (SchemeSocketFactory)HttpFactory.getSSLSocketFactory());
            httpClient.getConnectionManager().getSchemeRegistry().register(sch);
        }
        return httpClient;
    }

    private ThreadSafeClientConnManager createThreadSafeClientConnManager(ClientConfiguration clientConfig) {
        ThreadSafeClientConnManager connMgr = new ThreadSafeClientConnManager();
        connMgr.setDefaultMaxPerRoute(clientConfig.getMaxConnections());
        connMgr.setMaxTotal(clientConfig.getMaxConnections());
        return connMgr;
    }

    public HttpRequestBase createHttpRequest(ServiceClient.Request request, String charset) {
        HttpPost httpRequest;
        String uri = request.getUri();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() != null) {
                postMethod.setEntity((HttpEntity)new RepeatableInputStreamEntity(request));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            if (request.getContent() != null) {
                putMethod.setEntity((HttpEntity)new RepeatableInputStreamEntity(request));
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported HTTP method\uff1a%s.", request.getMethod().toString()));
        }
        this.configureRequestHeaders(request, charset, (HttpRequestBase)httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(ServiceClient.Request request, String charset, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + charset.toLowerCase());
        }
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, null);
            SSLSocketFactory ssf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return ssf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

