/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2.netty;

import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionStatus;
import com.aliyun.openservices.iot.api.http2.connection.impl.ConnectionImpl;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttp2Handler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private static final Logger log = LoggerFactory.getLogger(NettyHttp2Handler.class);
    private long heartbeatTimeoutThreshold;
    private long lastHeartBeatTime;
    private Connection connection;

    NettyHttp2Handler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, long heartbeatTimeoutThreshold) {
        super(decoder, encoder, initialSettings);
        this.heartbeatTimeoutThreshold = heartbeatTimeoutThreshold;
    }

    public Connection getConnection() {
        if (this.connection == null) {
            log.error("failed to get connection, netty handler not initialized correctly");
        }
        return this.connection;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        super.channelRead(ctx, msg);
        this.resetHeartBeatTime();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.connection = new ConnectionImpl(this, ctx);
        this.connection.setStatus(ConnectionStatus.CREATING);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        log.debug("onDataRead, streamId: {}, size: {}, ES: {}", new Object[]{streamId, data.readableBytes(), endOfStream});
        return this.connection.onDataRead(ctx, streamId, data, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, this.connection().connectionStream().id(), (short)16, false, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        log.debug("onHeadersRead, streamId: {}, header: {}, weight: {}, dependency: {}, exclusive: {}, isEnd: {}", new Object[]{streamId, headers, streamDependency, weight, exclusive, endOfStream});
        this.connection.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
        log.debug("onPriorityRead, streamId: {}, streamDependency: {}, weight: {}, exclusive: {}", new Object[]{streamId, streamDependency, weight, exclusive});
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        log.debug("onRstStreamRead, streamId: {}, errorCode: {}", (Object)streamId, (Object)errorCode);
        this.connection.onRstStreamRead(ctx, streamId, errorCode);
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
        log.debug("onSettingsAckRead");
        this.connection.setStatus(ConnectionStatus.CREATED);
    }

    public void onError(ChannelHandlerContext ctx, boolean outbound, Throwable cause) {
        super.onError(ctx, outbound, cause);
        log.error("error occurs, close channel. channel id: {}, outbound: {}, error:", new Object[]{ctx.channel(), outbound, cause});
        this.connection.onError(ctx, outbound, cause);
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        log.debug("onSettingsRead, settings: {}", (Object)settings.toString());
        this.connection.onSettingsRead(ctx, settings);
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
        log.debug("onPingRead, data: {}", (Object)data);
        this.encoder().frameWriter().writePing(ctx, true, data, ctx.voidPromise());
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
        log.debug("onPingAckRead, data: {}", (Object)data);
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        log.debug("onPushPromiseRead, streamId: {}, promisedStreamId: {}, headers size: {}", new Object[]{streamId, promisedStreamId, headers.size()});
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        log.debug("onGoAwayRead, lastStreamId: {}, errorCode: {}, {}", new Object[]{lastStreamId, errorCode, new String(ByteBufUtil.getBytes((ByteBuf)debugData))});
        this.connection.onGoAwayRead(ctx, lastStreamId, errorCode, debugData);
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
        log.debug("onWindowUpdateRead, streamId: {}, increment size: {}", (Object)streamId, (Object)windowSizeIncrement);
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
        log.debug("onUnknownFrame, frameType: {}, streamId: {}, size: {}, flags: {}", new Object[]{frameType, streamId, payload.readableBytes(), flags.toString()});
        this.connection.onUnknownFrame(ctx, frameType, streamId, flags, payload);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        log.error("exceptionCaught: ", (Throwable)new Exception(cause));
        this.connection.onError(ctx, false, cause);
        this.connection.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && ((event = (IdleStateEvent)evt).state() == IdleState.READER_IDLE || event.state() == IdleState.WRITER_IDLE)) {
            if (this.isTimeout()) {
                log.error("connection heartbeat timeout, channel:[{}], remote address:[{}] ", (Object)ctx.channel().id(), (Object)ctx.channel().remoteAddress());
                throw new IOException("connection heartbeat timeout");
            }
            log.debug("send heartbeat, channel:[{}], remote address:[{}] ", (Object)ctx.channel().id(), (Object)ctx.channel().remoteAddress());
            this.encoder().frameWriter().writePing(ctx, false, System.currentTimeMillis(), ctx.voidPromise());
            ctx.pipeline().flush();
        }
    }

    private boolean isTimeout() {
        return System.currentTimeMillis() - this.lastHeartBeatTime > this.heartbeatTimeoutThreshold;
    }

    private void resetHeartBeatTime() {
        this.lastHeartBeatTime = System.currentTimeMillis();
    }
}

