/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2.netty;

import com.aliyun.openservices.iot.api.http2.netty.NettyHttp2Handler;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import java.util.HashMap;
import java.util.Map;

public class NettyHttp2HandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<NettyHttp2Handler, NettyHttp2HandlerBuilder> {
    private long heartbeatTimeoutThreshold;
    private String frameLogLevel = "debug";
    private Map<String, LogLevel> logLevelMap = new HashMap<String, LogLevel>(){
        {
            this.put("trace", LogLevel.TRACE);
            this.put("debug", LogLevel.DEBUG);
            this.put("info", LogLevel.INFO);
            this.put("warn", LogLevel.WARN);
            this.put("error", LogLevel.ERROR);
        }
    };

    public NettyHttp2HandlerBuilder(long heartbeatTimeoutThreshold) {
        this.heartbeatTimeoutThreshold = heartbeatTimeoutThreshold;
        this.frameLogger(this.getFrameLogger());
    }

    protected NettyHttp2Handler build() {
        return (NettyHttp2Handler)super.build();
    }

    protected NettyHttp2Handler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        NettyHttp2Handler handler = new NettyHttp2Handler(decoder, encoder, initialSettings, this.heartbeatTimeoutThreshold);
        this.frameListener(handler);
        this.initialSettings().pushEnabled(true);
        this.initialSettings().initialWindowSize(0x40000000);
        this.initialSettings().maxFrameSize(0x100000);
        return handler;
    }

    private Http2FrameLogger getFrameLogger() {
        LogLevel logLevel = this.logLevelMap.getOrDefault(this.frameLogLevel.toLowerCase(), LogLevel.INFO);
        return new Http2FrameLogger(logLevel, ((Object)((Object)this)).getClass());
    }

    protected boolean isServer() {
        return false;
    }
}

