/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.util;

import com.aliyun.openservices.iot.api.http2.callback.Http2StreamListener;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.stream.StreamServiceContext;
import com.google.common.collect.Maps;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StreamUtil {
    public static final String PATH_STREAM_REGISTER = "/stream/register";
    public static final String PATH_STREAM_UNREGISTER = "/stream/unregister";
    public static final String PATH_STREAM_OPEN = "/stream/open";
    public static final String PATH_STREAM_CLOSE = "/stream/close";
    public static final String PATH_STREAM_SEND = "/stream/send";
    public static final String PATH_STREAM_CLOSE_FROM_RECEIVER = "/stream/receiver_close";
    public static final String DATA_STREAM_ID = "x-data-stream-id";

    public static void setupConnection(Connection connection, Http2StreamListener http2StreamListener) {
        connection.setDefaultStreamListener(http2StreamListener);
        Http2Connection.PropertyKey key = connection.getPropertyKey("streams");
        connection.setProperty(key, Maps.newConcurrentMap());
    }

    public static Map<String, StreamServiceContext> getDataStreamMaps(Connection connection) {
        Http2Connection.PropertyKey key = connection.getPropertyKey("streams");
        return (Map)connection.getProperty(key);
    }

    public static Optional<StreamServiceContext> getDataStreamContext(List<Connection> connections, String dataStreamId) {
        return connections.stream().filter(c -> StreamUtil.hasDataStream(c, dataStreamId)).findFirst().map(c -> StreamUtil.getDataStreamContext(c, dataStreamId));
    }

    private static boolean hasDataStream(Connection connection, String dataStreamId) {
        if (StreamUtil.getDataStreamMaps(connection) == null) {
            return false;
        }
        return StreamUtil.getDataStreamMaps(connection).containsKey(dataStreamId);
    }

    public static void putDataStreamContext(Connection connection, String dataStreamId, StreamServiceContext context) {
        StreamUtil.getDataStreamMaps(connection).put(dataStreamId, context);
    }

    private static StreamServiceContext getDataStreamContext(Connection connection, String streamId) {
        return StreamUtil.getDataStreamMaps(connection).get(streamId);
    }

    public static void removeDataStreamContext(Connection connection, String streamId) {
        StreamUtil.getDataStreamMaps(connection).remove(streamId);
    }

    public static String getDataStreamId(Http2Headers headers) {
        if (headers.contains((Object)DATA_STREAM_ID)) {
            return ((CharSequence)headers.get((Object)DATA_STREAM_ID)).toString();
        }
        return null;
    }

    public static void checkServiceName(String serviceName) {
        if (!serviceName.startsWith("/")) {
            throw new IllegalArgumentException("service name should start with '/'");
        }
    }
}

