/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ons.open.trace.core.dispatch.impl;

import com.alibaba.ons.open.trace.core.common.OnsTraceConstants;
import com.alibaba.ons.open.trace.core.common.OnsTraceContext;
import com.alibaba.ons.open.trace.core.common.OnsTraceDataEncoder;
import com.alibaba.ons.open.trace.core.common.OnsTraceTransferBean;
import com.alibaba.ons.open.trace.core.dispatch.AsyncAppender;
import com.alibaba.ons.open.trace.core.hook.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.namesrv.TopAddressing;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;

public class AsyncTraceAppender
extends AsyncAppender {
    private static final Logger clientlog = ClientLogger.getLog();
    private final int batchSize;
    private List<OnsTraceTransferBean> transDataList = new ArrayList<OnsTraceTransferBean>();
    private final DefaultMQProducer traceProducer;
    private String currentRegionId;

    public AsyncTraceAppender(Properties properties) throws MQClientException {
        SessionCredentials sessionCredentials = new SessionCredentials();
        Properties sessionProperties = new Properties();
        sessionProperties.put("AccessKey", properties.getProperty("AccessKey"));
        sessionProperties.put("SecretKey", properties.getProperty("SecretKey"));
        sessionCredentials.updateContent(sessionProperties);
        this.traceProducer = new DefaultMQProducer(new ClientRPCHook(sessionCredentials));
        this.traceProducer.setProducerGroup("_INNER_TRACE_PRODUCER");
        this.traceProducer.setSendMsgTimeout(5000);
        this.traceProducer.setInstanceName(properties.getProperty("InstanceName", String.valueOf(System.currentTimeMillis())));
        String nameSrv = properties.getProperty(OnsTraceConstants.NAMESRV_ADDR);
        if (nameSrv == null) {
            TopAddressing topAddressing = new TopAddressing(properties.getProperty(OnsTraceConstants.ADDRSRV_URL));
            nameSrv = topAddressing.fetchNSAddr();
        }
        this.traceProducer.setNamesrvAddr(nameSrv);
        this.traceProducer.setVipChannelEnabled(false);
        int maxSize = Integer.parseInt(properties.getProperty("MaxMsgSize", "128000"));
        this.batchSize = Integer.parseInt(properties.getProperty("MaxBatchNum", "1"));
        this.traceProducer.setMaxMessageSize(maxSize - 10000);
        this.traceProducer.start();
    }

    @Override
    public void append(Object context) {
        OnsTraceContext traceContext = (OnsTraceContext)context;
        if (traceContext == null) {
            return;
        }
        this.currentRegionId = traceContext.getRegionId();
        OnsTraceTransferBean traceData = OnsTraceDataEncoder.encoderFromContextBean(traceContext);
        this.transDataList.add(traceData);
    }

    @Override
    public void flush() {
        if (this.transDataList.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(1024);
        int count = 0;
        HashSet<String> keySet = new HashSet<String>();
        for (OnsTraceTransferBean bean : this.transDataList) {
            keySet.addAll(bean.getTransKey());
            sb.append(bean.getTransData());
            if (++count < this.batchSize && sb.length() < this.traceProducer.getMaxMessageSize()) continue;
            this.sendTraceDataByMQ(keySet, sb.toString());
            sb.delete(0, sb.length());
            keySet.clear();
            count = 0;
        }
        if (count > 0) {
            this.sendTraceDataByMQ(keySet, sb.toString());
        }
        this.transDataList.clear();
    }

    public void sendTraceDataByMQ(Set<String> keySet, String data) {
        String topic = "rmq_sys_TRACE_DATA_" + this.currentRegionId;
        final Message message = new Message(topic, data.getBytes());
        message.setKeys(keySet);
        try {
            this.traceProducer.send(message, new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                }

                @Override
                public void onException(Throwable e) {
                    clientlog.info("send trace data failed ,the msgidSet is" + message.getKeys());
                }
            }, 5000L);
        }
        catch (Exception e) {
            clientlog.info("send trace data failed ,the msgidSet is" + message.getKeys());
        }
    }
}

