/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceConstants;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceAppender;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceDispatcher;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsConsumeMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.order.ConsumeOrderContext;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderAction;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.MessageListenerOrderly;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class OrderConsumerImpl
extends ONSClientAbstract
implements OrderConsumer {
    private static final Logger log = ClientLoggerUtil.getClientLogger();
    private final DefaultMQPushConsumer defaultMQPushConsumer;
    private final ConcurrentHashMap<String, MessageOrderListener> subscribeTable = new ConcurrentHashMap();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private AsyncDispatcher traceDispatcher = null;

    public OrderConsumerImpl(Properties properties) {
        super(properties);
        String consumeTimeout;
        String maxReconsumeTimes;
        this.defaultMQPushConsumer = new DefaultMQPushConsumer(new ClientRPCHook(this.sessionCredentials));
        String consumerGroup = properties.getProperty("ConsumerId");
        if (null == consumerGroup) {
            throw new ONSClientException("'ConsumerId' property is null");
        }
        String suspendTimeMillis = properties.getProperty("suspendTimeMillis");
        if (!UtilAll.isBlank(suspendTimeMillis)) {
            try {
                this.defaultMQPushConsumer.setSuspendCurrentQueueTimeMillis(Long.parseLong(suspendTimeMillis));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!UtilAll.isBlank(maxReconsumeTimes = properties.getProperty("maxReconsumeTimes"))) {
            try {
                this.defaultMQPushConsumer.setMaxReconsumeTimes(Integer.parseInt(maxReconsumeTimes));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!UtilAll.isBlank(consumeTimeout = properties.getProperty("consumeTimeout"))) {
            try {
                this.defaultMQPushConsumer.setConsumeTimeout(Integer.parseInt(consumeTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.defaultMQPushConsumer.setVipChannelEnabled(isVipChannelEnabled);
        this.defaultMQPushConsumer.setConsumerGroup(consumerGroup);
        this.defaultMQPushConsumer.setInstanceName(this.buildIntanceName());
        this.defaultMQPushConsumer.setNamesrvAddr(this.getNameServerAddr());
        if (properties.containsKey("ConsumeThreadNums")) {
            this.defaultMQPushConsumer.setConsumeThreadMin(Integer.valueOf(properties.get("ConsumeThreadNums").toString()));
            this.defaultMQPushConsumer.setConsumeThreadMax(Integer.valueOf(properties.get("ConsumeThreadNums").toString()));
        }
        try {
            Properties tempProperties = new Properties();
            tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
            tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
            tempProperties.put("MaxMsgSize", "128000");
            tempProperties.put("AsyncBufferSize", "2048");
            tempProperties.put("MaxBatchNum", "1");
            tempProperties.put("WakeUpNum", "1");
            tempProperties.put(OnsTraceConstants.NAMESRV_ADDR, this.getNameServerAddr());
            tempProperties.put("InstanceName", this.buildIntanceName());
            AsyncTraceAppender appender = new AsyncTraceAppender(tempProperties);
            this.traceDispatcher = new AsyncTraceDispatcher(tempProperties);
            this.traceDispatcher.start(appender, this.defaultMQPushConsumer.getInstanceName());
            this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().registerConsumeMessageHook(new OnsConsumeMessageHookImpl(this.traceDispatcher));
        }
        catch (Throwable e) {
            log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
        }
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new MessageListenerOrderlyImpl());
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQPushConsumer.start();
            }
        }
        catch (Exception e) {
            throw new ONSClientException(e);
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.defaultMQPushConsumer.shutdown();
            if (this.traceDispatcher != null) {
                try {
                    this.traceDispatcher.flush();
                }
                catch (IOException e) {
                    log.error("system mqtrace hook shutdown failed ,maybe loss some trace data");
                }
            }
        }
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageOrderListener listener) {
        if (null == topic) {
            throw new ONSClientException("topic is null");
        }
        if (null == listener) {
            throw new ONSClientException("listener is null");
        }
        try {
            this.subscribeTable.put(topic, listener);
            this.defaultMQPushConsumer.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            throw new ONSClientException("defaultMQPushConsumer subscribe exception", e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isClosed() {
        return !this.isStarted();
    }

    class MessageListenerOrderlyImpl
    implements MessageListenerOrderly {
        MessageListenerOrderlyImpl() {
        }

        @Override
        public ConsumeOrderlyStatus consumeMessage(List<MessageExt> arg0, ConsumeOrderlyContext arg1) {
            MessageExt msgRMQ = arg0.get(0);
            Message msg = ONSUtil.msgConvert(msgRMQ);
            msg.setMsgID(msgRMQ.getMsgId());
            MessageOrderListener listener = (MessageOrderListener)OrderConsumerImpl.this.subscribeTable.get(msg.getTopic());
            if (null == listener) {
                throw new ONSClientException("MessageOrderListener is null");
            }
            ConsumeOrderContext context = new ConsumeOrderContext();
            OrderAction action = listener.consume(msg, context);
            if (action != null) {
                switch (action) {
                    case Success: {
                        return ConsumeOrderlyStatus.SUCCESS;
                    }
                    case Suspend: {
                        return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                    }
                }
            }
            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        }
    }
}

