/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ProcessQueueInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;

public class ProcessQueue {
    public static final long RebalanceLockMaxLiveTime = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockMaxLiveTime", "30000"));
    public static final long RebalanceLockInterval = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockInterval", "20000"));
    private static final long PullMaxIdleTime = Long.parseLong(System.getProperty("rocketmq.client.pull.pullMaxIdleTime", "120000"));
    private final Logger log = ClientLogger.getLog();
    private final ReadWriteLock lockTreeMap = new ReentrantReadWriteLock();
    private final TreeMap<Long, MessageExt> msgTreeMap = new TreeMap();
    private final AtomicLong msgCount = new AtomicLong();
    private final Lock lockConsume = new ReentrantLock();
    private final TreeMap<Long, MessageExt> msgTreeMapTemp = new TreeMap();
    private final AtomicLong tryUnlockTimes = new AtomicLong(0L);
    private volatile long queueOffsetMax = 0L;
    private volatile boolean dropped = false;
    private volatile long lastPullTimestamp = System.currentTimeMillis();
    private volatile long lastConsumeTimestamp = System.currentTimeMillis();
    private volatile boolean locked = false;
    private volatile long lastLockTimestamp = System.currentTimeMillis();
    private volatile boolean consuming = false;
    private volatile long msgAccCnt = 0L;

    public boolean isLockExpired() {
        boolean result = System.currentTimeMillis() - this.lastLockTimestamp > RebalanceLockMaxLiveTime;
        return result;
    }

    public boolean isPullExpired() {
        boolean result = System.currentTimeMillis() - this.lastPullTimestamp > PullMaxIdleTime;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredMsg(DefaultMQPushConsumer pushConsumer) {
        if (pushConsumer.getDefaultMQPushConsumerImpl().isConsumeOrderly()) {
            return;
        }
        int loop = this.msgTreeMap.size() < 16 ? this.msgTreeMap.size() : 16;
        for (int i = 0; i < loop; ++i) {
            Message msg = null;
            try {
                this.lockTreeMap.readLock().lockInterruptibly();
                try {
                    if (this.msgTreeMap.isEmpty() || System.currentTimeMillis() - Long.valueOf(MessageAccessor.getConsumeStartTimeStamp(this.msgTreeMap.firstEntry().getValue())) <= pushConsumer.getConsumeTimeout() * 60L * 1000L) break;
                    msg = this.msgTreeMap.firstEntry().getValue();
                }
                finally {
                    this.lockTreeMap.readLock().unlock();
                }
            }
            catch (InterruptedException e) {
                this.log.error("getExpiredMsg exception", (Throwable)e);
            }
            try {
                pushConsumer.sendMessageBack((MessageExt)msg, 3);
                this.log.info("send expire msg back. topic={}, msgId={}, storeHost={}, queueId={}, queueOffset={}", new Object[]{msg.getTopic(), ((MessageExt)msg).getMsgId(), ((MessageExt)msg).getStoreHost(), ((MessageExt)msg).getQueueId(), ((MessageExt)msg).getQueueOffset()});
                try {
                    this.lockTreeMap.writeLock().lockInterruptibly();
                    try {
                        if (this.msgTreeMap.isEmpty() || ((MessageExt)msg).getQueueOffset() != this.msgTreeMap.firstKey().longValue()) continue;
                        try {
                            this.msgTreeMap.remove(this.msgTreeMap.firstKey());
                        }
                        catch (Exception e) {
                            this.log.error("send expired msg exception", (Throwable)e);
                        }
                    }
                    finally {
                        this.lockTreeMap.writeLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    this.log.error("getExpiredMsg exception", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                this.log.error("send expired msg exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessage(List<MessageExt> msgs) {
        boolean dispatchToConsume = false;
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                long accTotal;
                MessageExt messageExt;
                String property;
                int validMsgCnt = 0;
                for (MessageExt msg : msgs) {
                    MessageExt old = this.msgTreeMap.put(msg.getQueueOffset(), msg);
                    if (null != old) continue;
                    ++validMsgCnt;
                    this.queueOffsetMax = msg.getQueueOffset();
                }
                this.msgCount.addAndGet(validMsgCnt);
                if (!this.msgTreeMap.isEmpty() && !this.consuming) {
                    dispatchToConsume = true;
                    this.consuming = true;
                }
                if (!msgs.isEmpty() && (property = (messageExt = msgs.get(msgs.size() - 1)).getProperty("MAX_OFFSET")) != null && (accTotal = Long.parseLong(property) - messageExt.getQueueOffset()) > 0L) {
                    this.msgAccCnt = accTotal;
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("putMessage exception", (Throwable)e);
        }
        return dispatchToConsume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxSpan() {
        try {
            this.lockTreeMap.readLock().lockInterruptibly();
            try {
                if (this.msgTreeMap.isEmpty()) return 0L;
                long l = this.msgTreeMap.lastKey() - this.msgTreeMap.firstKey();
                return l;
            }
            finally {
                this.lockTreeMap.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("getMaxSpan exception", (Throwable)e);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeMessage(List<MessageExt> msgs) {
        long result = -1L;
        long now = System.currentTimeMillis();
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            this.lastConsumeTimestamp = now;
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    result = this.queueOffsetMax + 1L;
                    int removedCnt = 0;
                    for (MessageExt msg : msgs) {
                        MessageExt prev = this.msgTreeMap.remove(msg.getQueueOffset());
                        if (prev == null) continue;
                        --removedCnt;
                    }
                    this.msgCount.addAndGet(removedCnt);
                    if (!this.msgTreeMap.isEmpty()) {
                        result = this.msgTreeMap.firstKey();
                    }
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (Throwable t) {
            this.log.error("removeMessage exception", t);
        }
        return result;
    }

    public TreeMap<Long, MessageExt> getMsgTreeMap() {
        return this.msgTreeMap;
    }

    public AtomicLong getMsgCount() {
        return this.msgCount;
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public void setDropped(boolean dropped) {
        this.dropped = dropped;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                this.msgTreeMap.putAll(this.msgTreeMapTemp);
                this.msgTreeMapTemp.clear();
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("rollback exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long commit() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                Long offset = this.msgTreeMapTemp.lastKey();
                this.msgCount.addAndGet(this.msgTreeMapTemp.size() * -1);
                this.msgTreeMapTemp.clear();
                if (offset == null) return -1L;
                long l = offset + 1L;
                return l;
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("commit exception", (Throwable)e);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeMessageToCosumeAgain(List<MessageExt> msgs) {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                for (MessageExt msg : msgs) {
                    this.msgTreeMapTemp.remove(msg.getQueueOffset());
                    this.msgTreeMap.put(msg.getQueueOffset(), msg);
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("makeMessageToCosumeAgain exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageExt> takeMessags(int batchSize) {
        ArrayList<MessageExt> result = new ArrayList<MessageExt>(batchSize);
        long now = System.currentTimeMillis();
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            this.lastConsumeTimestamp = now;
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    Map.Entry<Long, MessageExt> entry;
                    for (int i = 0; i < batchSize && (entry = this.msgTreeMap.pollFirstEntry()) != null; ++i) {
                        result.add(entry.getValue());
                        this.msgTreeMapTemp.put(entry.getKey(), entry.getValue());
                    }
                }
                if (result.isEmpty()) {
                    this.consuming = false;
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("take Messages exception", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTempMessage() {
        this.lockTreeMap.readLock().lockInterruptibly();
        try {
            boolean bl = !this.msgTreeMap.isEmpty();
            this.lockTreeMap.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lockTreeMap.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                this.msgTreeMap.clear();
                this.msgTreeMapTemp.clear();
                this.msgCount.set(0L);
                this.queueOffsetMax = 0L;
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("rollback exception", (Throwable)e);
        }
    }

    public long getLastLockTimestamp() {
        return this.lastLockTimestamp;
    }

    public void setLastLockTimestamp(long lastLockTimestamp) {
        this.lastLockTimestamp = lastLockTimestamp;
    }

    public Lock getLockConsume() {
        return this.lockConsume;
    }

    public long getLastPullTimestamp() {
        return this.lastPullTimestamp;
    }

    public void setLastPullTimestamp(long lastPullTimestamp) {
        this.lastPullTimestamp = lastPullTimestamp;
    }

    public long getMsgAccCnt() {
        return this.msgAccCnt;
    }

    public void setMsgAccCnt(long msgAccCnt) {
        this.msgAccCnt = msgAccCnt;
    }

    public long getTryUnlockTimes() {
        return this.tryUnlockTimes.get();
    }

    public void incTryUnlockTimes() {
        this.tryUnlockTimes.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillProcessQueueInfo(ProcessQueueInfo info) {
        try {
            this.lockTreeMap.readLock().lockInterruptibly();
            if (!this.msgTreeMap.isEmpty()) {
                info.setCachedMsgMinOffset(this.msgTreeMap.firstKey());
                info.setCachedMsgMaxOffset(this.msgTreeMap.lastKey());
                info.setCachedMsgCount(this.msgTreeMap.size());
            }
            if (!this.msgTreeMapTemp.isEmpty()) {
                info.setTransactionMsgMinOffset(this.msgTreeMapTemp.firstKey());
                info.setTransactionMsgMaxOffset(this.msgTreeMapTemp.lastKey());
                info.setTransactionMsgCount(this.msgTreeMapTemp.size());
            }
            info.setLocked(this.locked);
            info.setTryUnlockTimes(this.tryUnlockTimes.get());
            info.setLastLockTimestamp(this.lastLockTimestamp);
            info.setDroped(this.dropped);
            info.setLastPullTimestamp(this.lastPullTimestamp);
            info.setLastConsumeTimestamp(this.lastConsumeTimestamp);
        }
        catch (Exception exception) {
        }
        finally {
            this.lockTreeMap.readLock().unlock();
        }
    }

    public long getLastConsumeTimestamp() {
        return this.lastConsumeTimestamp;
    }

    public void setLastConsumeTimestamp(long lastConsumeTimestamp) {
        this.lastConsumeTimestamp = lastConsumeTimestamp;
    }
}

