/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.common.ThreadLocalIndex;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultTolerance;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;

public class LatencyFaultToleranceImpl
implements LatencyFaultTolerance<String> {
    private final ConcurrentHashMap<String, FaultItem> faultItemTable = new ConcurrentHashMap(16);
    private final ThreadLocalIndex whichItemWorst = new ThreadLocalIndex(0);

    @Override
    public void updateFaultItem(String name, long currentLatency, long notAvailableDuration) {
        FaultItem old = this.faultItemTable.get(name);
        if (null == old) {
            FaultItem faultItem = new FaultItem(name);
            faultItem.setCurrentLatency(currentLatency);
            faultItem.setStartTimestamp(System.currentTimeMillis() + notAvailableDuration);
            old = this.faultItemTable.putIfAbsent(name, faultItem);
            if (old != null) {
                old.setCurrentLatency(currentLatency);
                old.setStartTimestamp(System.currentTimeMillis() + notAvailableDuration);
            }
        } else {
            old.setCurrentLatency(currentLatency);
            old.setStartTimestamp(System.currentTimeMillis() + notAvailableDuration);
        }
    }

    @Override
    public boolean isAvailable(String name) {
        FaultItem faultItem = this.faultItemTable.get(name);
        if (faultItem != null) {
            return faultItem.isAvailable();
        }
        return true;
    }

    @Override
    public String pickOneAtLeast() {
        Enumeration<FaultItem> elements = this.faultItemTable.elements();
        LinkedList<FaultItem> tmpList = new LinkedList<FaultItem>();
        while (elements.hasMoreElements()) {
            FaultItem faultItem = elements.nextElement();
            tmpList.add(faultItem);
        }
        if (!tmpList.isEmpty()) {
            Collections.shuffle(tmpList);
            Collections.sort(tmpList);
            int half = tmpList.size() / 2;
            if (half <= 0) {
                return ((FaultItem)tmpList.get(0)).getName();
            }
            int i = this.whichItemWorst.getAndIncrement() % half;
            return ((FaultItem)tmpList.get(i)).getName();
        }
        return null;
    }

    public String toString() {
        return "LatencyFaultToleranceImpl{faultItemTable=" + this.faultItemTable + ", whichItemWorst=" + this.whichItemWorst + '}';
    }

    class FaultItem
    implements Comparable<FaultItem> {
        private final String name;
        private volatile long currentLatency;
        private volatile long startTimestamp;

        public FaultItem(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(FaultItem other) {
            if (this.isAvailable() != other.isAvailable()) {
                if (this.isAvailable()) {
                    return -1;
                }
                if (other.isAvailable()) {
                    return 1;
                }
            }
            if (this.currentLatency < other.currentLatency) {
                return -1;
            }
            if (this.currentLatency > other.currentLatency) {
                return 1;
            }
            if (this.startTimestamp < other.startTimestamp) {
                return -1;
            }
            if (this.startTimestamp > other.startTimestamp) {
                return 1;
            }
            return 0;
        }

        public boolean isAvailable() {
            return System.currentTimeMillis() - this.startTimestamp >= 0L;
        }

        public int hashCode() {
            int result = this.getName() != null ? this.getName().hashCode() : 0;
            result = 31 * result + (int)(this.getCurrentLatency() ^ this.getCurrentLatency() >>> 32);
            result = 31 * result + (int)(this.getStartTimestamp() ^ this.getStartTimestamp() >>> 32);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FaultItem)) {
                return false;
            }
            FaultItem faultItem = (FaultItem)o;
            if (this.getCurrentLatency() != faultItem.getCurrentLatency()) {
                return false;
            }
            if (this.getStartTimestamp() != faultItem.getStartTimestamp()) {
                return false;
            }
            return this.getName() != null ? this.getName().equals(faultItem.getName()) : faultItem.getName() == null;
        }

        public String toString() {
            return "FaultItem{name='" + this.name + '\'' + ", currentLatency=" + this.currentLatency + ", startTimestamp=" + this.startTimestamp + '}';
        }

        public String getName() {
            return this.name;
        }

        public long getCurrentLatency() {
            return this.currentLatency;
        }

        public void setCurrentLatency(long currentLatency) {
            this.currentLatency = currentLatency;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public void setStartTimestamp(long startTimestamp) {
            this.startTimestamp = startTimestamp;
        }
    }
}

