/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metaq.client.eagleeye;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.org.apache.commons.lang.StringUtils;
import com.taobao.mqtrace.common.MQTraceBean;
import com.taobao.mqtrace.common.MQTraceConstants;
import com.taobao.mqtrace.common.MQTraceContext;
import com.taobao.mqtrace.common.MQTraceLogUtils;
import com.taobao.mqtrace.common.MQType;
import com.taobao.mqtrace.sub.MQConsumeMessageTraceLog;
import java.util.ArrayList;

public class ConsumeMessageHookImpl
implements ConsumeMessageHook,
MQTraceConstants {
    @Override
    public String hookName() {
        return "EagleEyeConsumeMessageHook";
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext context) {
        if (context == null || !MQTraceLogUtils.isTraceLogOn((String)context.getConsumerGroup()) || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        MQTraceContext mqTraceContext = new MQTraceContext();
        context.setMqTraceContext(mqTraceContext);
        mqTraceContext.setMqType(MQType.METAQ);
        mqTraceContext.setGroup(context.getConsumerGroup());
        ArrayList<MQTraceBean> beans = new ArrayList<MQTraceBean>();
        for (MessageExt msg : context.getMsgList()) {
            if (msg == null) continue;
            MQTraceBean traceBean = new MQTraceBean();
            traceBean.setTraceId(msg.getProperty("eagleTraceId"));
            traceBean.setRpcId(msg.getProperty("eagleRpcId"));
            traceBean.setEagleEyeUserData(msg.getProperty("eagleData"));
            traceBean.setTopic(msg.getTopic());
            traceBean.setMsgId(msg.getMsgId());
            traceBean.setOriginMsgId(MessageAccessor.getOriginMessageId(msg));
            traceBean.setTags(msg.getTags());
            traceBean.setKeys(msg.getKeys());
            traceBean.setBuyerId(msg.getBuyerId());
            traceBean.setTransferFlag(MessageAccessor.getTransferFlag(msg));
            traceBean.setCorrectionFlag(MessageAccessor.getCorrectionFlag(msg));
            traceBean.setBodyLength(msg.getBody().length);
            traceBean.setBornHost(StringUtils.substring((String)msg.getBornHost().toString(), (int)1));
            traceBean.setStoreHost(StringUtils.substring((String)msg.getStoreHost().toString(), (int)1));
            traceBean.setStoreTime(msg.getStoreTimestamp());
            traceBean.setBrokerName(context.getMq().getBrokerName());
            traceBean.setQueueId(msg.getQueueId());
            traceBean.setOffset(msg.getQueueOffset());
            traceBean.setRetryTimes(msg.getReconsumeTimes());
            traceBean.setProps(context.getProps());
            beans.add(traceBean);
        }
        mqTraceContext.setTraceBeans(beans);
        MQConsumeMessageTraceLog.consumeMessageBefore((MQTraceContext)mqTraceContext);
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext context) {
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty() || !MQTraceLogUtils.isTraceLogOn((String)context.getConsumerGroup())) {
            return;
        }
        MQTraceContext mqTraceContext = (MQTraceContext)context.getMqTraceContext();
        mqTraceContext.setSuccess(context.isSuccess());
        mqTraceContext.setStatus(context.getStatus());
        MQConsumeMessageTraceLog.consumeMessageAfter((MQTraceContext)mqTraceContext);
    }
}

