/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metaq.client.eagleeye;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.org.apache.commons.lang.StringUtils;
import com.taobao.mqtrace.common.MQTraceBean;
import com.taobao.mqtrace.common.MQTraceConstants;
import com.taobao.mqtrace.common.MQTraceContext;
import com.taobao.mqtrace.common.MQTraceLogUtils;
import com.taobao.mqtrace.common.MQType;
import com.taobao.mqtrace.pub.MQSendMessageTraceLog;
import java.util.ArrayList;

public class SendMessageHookImpl
implements SendMessageHook,
MQTraceConstants {
    @Override
    public String hookName() {
        return "EagleEyeSendMessageHook";
    }

    @Override
    public void sendMessageBefore(SendMessageContext context) {
        if (context == null || context.getMessage() == null || !MQTraceLogUtils.isTraceLogOn((String)context.getProducerGroup())) {
            return;
        }
        MQTraceContext mqTraceContext = new MQTraceContext();
        context.setMqTraceContext(mqTraceContext);
        mqTraceContext.setMqType(MQType.METAQ);
        mqTraceContext.setGroup(context.getProducerGroup());
        mqTraceContext.setAsync(CommunicationMode.ASYNC.equals((Object)context.getCommunicationMode()));
        Message msg = context.getMessage();
        if (msg == null) {
            return;
        }
        MQTraceBean traceBean = new MQTraceBean();
        traceBean.setTopic(msg.getTopic());
        traceBean.setOriginMsgId(MessageAccessor.getOriginMessageId(msg));
        traceBean.setTags(msg.getTags());
        traceBean.setKeys(msg.getKeys());
        traceBean.setBuyerId(msg.getBuyerId());
        traceBean.setTransferFlag(MessageAccessor.getTransferFlag(msg));
        traceBean.setCorrectionFlag(MessageAccessor.getCorrectionFlag(msg));
        traceBean.setBodyLength(msg.getBody().length);
        traceBean.setBornHost(context.getBornHost());
        traceBean.setStoreHost(context.getBrokerAddr());
        traceBean.setBrokerName(context.getMq().getBrokerName());
        traceBean.setProps(context.getProps());
        ArrayList<MQTraceBean> beans = new ArrayList<MQTraceBean>();
        beans.add(traceBean);
        mqTraceContext.setTraceBeans(beans);
        if (StringUtils.isNotBlank((String)msg.getUserProperty("eagleTraceId"))) {
            traceBean.setTraceId(msg.getUserProperty("eagleTraceId"));
            traceBean.setRpcId(msg.getUserProperty("eagleRpcId"));
            traceBean.setEagleEyeUserData(msg.getUserProperty("eagleData"));
        }
        MQSendMessageTraceLog.sendMessageBefore((MQTraceContext)mqTraceContext);
        if (StringUtils.isBlank((String)msg.getProperty("eagleTraceId")) && StringUtils.isNotBlank((String)traceBean.getTraceId())) {
            msg.putUserProperty("eagleTraceId", traceBean.getTraceId());
            msg.putUserProperty("eagleRpcId", traceBean.getRpcId());
            msg.putUserProperty("eagleData", traceBean.getEagleEyeUserData());
        }
    }

    @Override
    public void sendMessageAfter(SendMessageContext context) {
        if (context == null || context.getMessage() == null || !MQTraceLogUtils.isTraceLogOn((String)context.getProducerGroup())) {
            return;
        }
        MQTraceContext mqTraceContext = (MQTraceContext)context.getMqTraceContext();
        MQTraceBean traceBean = (MQTraceBean)mqTraceContext.getTraceBeans().get(0);
        if (traceBean != null && context.getSendResult() != null) {
            traceBean.setQueueId(context.getMq().getQueueId());
            traceBean.setMsgId(context.getSendResult().getMsgId());
            traceBean.setOffset(context.getSendResult().getQueueOffset());
            mqTraceContext.setSuccess(true);
            mqTraceContext.setStatus(context.getSendResult().getSendStatus().toString());
        } else if (context.getException() != null) {
            String msg = context.getException().getMessage();
            mqTraceContext.setErrorMsg(StringUtils.substring((String)msg, (int)0, (int)msg.indexOf("\n")));
        }
        MQSendMessageTraceLog.sendMessageAfter((MQTraceContext)mqTraceContext);
    }
}

